/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Crystal;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.tools.LoggingTool;

public class CIFReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private LoggingTool logger;
    private Crystal crystal = null;
    private double a = 0.0;
    private double b = 0.0;
    private double c = 0.0;
    private double alpha = 0.0;
    private double beta = 0.0;
    private double gamma = 0.0;

    public CIFReader(Reader input) {
        this.input = new BufferedReader(input);
        this.logger = new LoggingTool(this.getClass().getName());
    }

    public CIFReader() {
        this(new StringReader(""));
    }

    public String getFormatName() {
        return "CIF-like (not CIF)";
    }

    public void setReader(Reader reader) throws CDKException {
        this.input = this.input;
    }

    public boolean matches(int lineNumber, String line) {
        return line.startsWith("_cell_length_a") || line.startsWith("_audit_creation_date") || line.startsWith("loop_");
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemFile) {
            ChemFile cf = null;
            try {
                cf = this.readChemFile();
            }
            catch (IOException e) {
                this.logger.error("Input/Output error while reading from input.");
            }
            return cf;
        }
        throw new CDKException("Only supported is reading of ChemFile.");
    }

    private ChemFile readChemFile() throws IOException {
        ChemFile file = new ChemFile();
        ChemSequence seq = new ChemSequence();
        ChemModel model = new ChemModel();
        this.crystal = new Crystal();
        String line = this.input.readLine();
        boolean end_found = false;
        while (this.input.ready() && line != null && !end_found) {
            if (line.startsWith("#")) {
                this.logger.warn("Skipping comment: " + line);
            } else if (line.length() == 0) {
                this.logger.debug("Skipping empty line");
            } else if (!line.startsWith("_") && !line.startsWith("loop_")) {
                this.logger.warn("Skipping unrecognized line: " + line);
            } else {
                String command;
                block18: {
                    command = "";
                    int spaceIndex = line.indexOf(" ");
                    if (spaceIndex != -1) {
                        try {
                            command = new String(line.substring(0, spaceIndex));
                            break block18;
                        }
                        catch (StringIndexOutOfBoundsException sioobe) {
                            break;
                        }
                    }
                    command = line;
                }
                this.logger.debug("command: " + command);
                if (command.startsWith("_cell")) {
                    this.processCellParameter(command, line);
                } else if (command.equals("loop_")) {
                    this.processLoopBlock();
                } else if (command.equals("_symmetry_space_group_name_H-M")) {
                    String value = line.substring(29).trim();
                    this.crystal.setSpaceGroup(value);
                } else {
                    this.logger.warn("Skipping command: " + command);
                    line = this.input.readLine();
                    if (line.startsWith(";")) {
                        this.logger.debug("Skipping block content");
                        line = this.input.readLine().trim();
                        while (!line.equals(";")) {
                            line = this.input.readLine().trim();
                            this.logger.debug("Skipping block line: " + line);
                        }
                        line = this.input.readLine();
                    }
                }
            }
            line = this.input.readLine();
        }
        this.logger.info("Adding crystal to file with #atoms: " + this.crystal.getAtomCount());
        model.setCrystal(this.crystal);
        seq.addChemModel(model);
        file.addChemSequence(seq);
        return file;
    }

    private void processCellParameter(String command, String line) {
        if ((command = command.substring(6)).equals("length_a")) {
            String value = line.substring(14).trim();
            this.a = this.parseIntoDouble(value);
            this.possiblySetCellParams(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
        } else if (command.equals("length_b")) {
            String value = line.substring(14).trim();
            this.b = this.parseIntoDouble(value);
            this.possiblySetCellParams(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
        } else if (command.equals("length_c")) {
            String value = line.substring(14).trim();
            this.c = this.parseIntoDouble(value);
            this.possiblySetCellParams(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
        } else if (command.equals("angle_alpha")) {
            String value = line.substring(17).trim();
            this.alpha = this.parseIntoDouble(value);
            this.possiblySetCellParams(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
        } else if (command.equals("angle_beta")) {
            String value = line.substring(16).trim();
            this.beta = this.parseIntoDouble(value);
            this.possiblySetCellParams(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
        } else if (command.equals("angle_gamma")) {
            String value = line.substring(17).trim();
            this.gamma = this.parseIntoDouble(value);
            this.possiblySetCellParams(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
        }
    }

    private void possiblySetCellParams(double a, double b, double c, double alpha, double beta, double gamma) {
        if (a != 0.0 && b != 0.0 && c != 0.0 && alpha != 0.0 && beta != 0.0 && gamma != 0.0) {
            this.logger.info("Found and set crystal cell parameters");
            double[][] axes = CrystalGeometryTools.notionalToCartesian(a, b, c, alpha, beta, gamma);
            this.crystal.setA(axes[0][0], axes[0][1], axes[0][2]);
            this.crystal.setB(axes[1][0], axes[1][1], axes[1][2]);
            this.crystal.setC(axes[2][0], axes[2][1], axes[2][2]);
        }
    }

    private void processLoopBlock() throws IOException {
        String line = this.input.readLine().trim();
        if (line.startsWith("_atom")) {
            this.logger.info("Found atom loop block");
            this.processAtomLoopBlock(line);
        } else {
            this.logger.warn("Skipping loop block");
            this.skipUntilEmptyOrCommentLine(line);
        }
    }

    private void skipUntilEmptyOrCommentLine(String line) throws IOException {
        while (line != null && line.length() > 0 && line.charAt(0) != '#') {
            line = this.input.readLine().trim();
        }
    }

    private void processAtomLoopBlock(String firstLine) throws IOException {
        int atomLabel = -1;
        int atomSymbol = -1;
        int atomFractX = -1;
        int atomFractY = -1;
        int atomFractZ = -1;
        int atomRealX = -1;
        int atomRealY = -1;
        int atomRealZ = -1;
        String line = firstLine.trim();
        int headerCount = 0;
        boolean hasParsableInformation = false;
        while (line != null && line.charAt(0) == '_') {
            ++headerCount;
            if (line.equals("_atom_site_label") || line.equals("_atom_site_label_atom_id")) {
                atomLabel = headerCount;
                hasParsableInformation = true;
                this.logger.info("label found in col: " + atomLabel);
            } else if (line.startsWith("_atom_site_fract_x")) {
                atomFractX = headerCount;
                hasParsableInformation = true;
                this.logger.info("frac x found in col: " + atomFractX);
            } else if (line.startsWith("_atom_site_fract_y")) {
                atomFractY = headerCount;
                hasParsableInformation = true;
                this.logger.info("frac y found in col: " + atomFractY);
            } else if (line.startsWith("_atom_site_fract_z")) {
                atomFractZ = headerCount;
                hasParsableInformation = true;
                this.logger.info("frac z found in col: " + atomFractZ);
            } else if (line.equals("_atom_site.Cartn_x")) {
                atomRealX = headerCount;
                hasParsableInformation = true;
                this.logger.info("cart x found in col: " + atomRealX);
            } else if (line.equals("_atom_site.Cartn_y")) {
                atomRealY = headerCount;
                hasParsableInformation = true;
                this.logger.info("cart y found in col: " + atomRealY);
            } else if (line.equals("_atom_site.Cartn_z")) {
                atomRealZ = headerCount;
                hasParsableInformation = true;
                this.logger.info("cart z found in col: " + atomRealZ);
            } else if (line.equals("_atom_site.type_symbol")) {
                atomSymbol = headerCount;
                hasParsableInformation = true;
                this.logger.info("type_symbol found in col: " + atomSymbol);
            } else {
                this.logger.warn("Ignoring atom loop block field: " + line);
            }
            line = this.input.readLine().trim();
        }
        if (!hasParsableInformation) {
            this.logger.info("No parsable info found");
            this.skipUntilEmptyOrCommentLine(line);
        } else {
            while (line != null && line.length() > 0 && line.charAt(0) != '#') {
                this.logger.debug("new row");
                StringTokenizer tokenizer = new StringTokenizer(line);
                if (tokenizer.countTokens() < headerCount) {
                    this.logger.warn("Column count mismatch; assuming continued on next line");
                    this.logger.debug("Found #expected, #found: " + headerCount + ", " + tokenizer.countTokens());
                    tokenizer = new StringTokenizer(line + this.input.readLine());
                }
                int colIndex = 0;
                Atom atom = new Atom("C");
                double[] frac = new double[3];
                double[] real = new double[3];
                boolean hasFractional = false;
                boolean hasCartesian = false;
                while (tokenizer.hasMoreTokens()) {
                    String field = tokenizer.nextToken();
                    this.logger.debug("Parsing col,token: " + ++colIndex + "=" + field);
                    if (colIndex == atomLabel) {
                        if (atomSymbol == -1) {
                            String element = this.extractFirstLetters(field);
                            atom.setSymbol(element);
                        }
                        atom.setID(field);
                        continue;
                    }
                    if (colIndex == atomFractX) {
                        hasFractional = true;
                        frac[0] = this.parseIntoDouble(field);
                        continue;
                    }
                    if (colIndex == atomFractY) {
                        hasFractional = true;
                        frac[1] = this.parseIntoDouble(field);
                        continue;
                    }
                    if (colIndex == atomFractZ) {
                        hasFractional = true;
                        frac[2] = this.parseIntoDouble(field);
                        continue;
                    }
                    if (colIndex == atomSymbol) {
                        atom.setSymbol(field);
                        continue;
                    }
                    if (colIndex == atomRealX) {
                        hasCartesian = true;
                        this.logger.debug("Adding x3: " + this.parseIntoDouble(field));
                        real[0] = this.parseIntoDouble(field);
                        continue;
                    }
                    if (colIndex == atomRealY) {
                        hasCartesian = true;
                        this.logger.debug("Adding y3: " + this.parseIntoDouble(field));
                        real[1] = this.parseIntoDouble(field);
                        continue;
                    }
                    if (colIndex != atomRealZ) continue;
                    hasCartesian = true;
                    this.logger.debug("Adding x3: " + this.parseIntoDouble(field));
                    real[2] = this.parseIntoDouble(field);
                }
                if (hasCartesian) {
                    double[] a = this.crystal.getA();
                    double[] b = this.crystal.getB();
                    double[] c = this.crystal.getC();
                    frac = CrystalGeometryTools.cartesianToFractional(a, b, c, real);
                    atom.setFractionalPoint3d(new Point3d(frac[0], frac[1], frac[2]));
                }
                if (hasFractional) {
                    atom.setFractionalPoint3d(new Point3d(frac[0], frac[1], frac[2]));
                }
                this.logger.debug("Adding atom: " + atom);
                this.crystal.addAtom(atom);
                line = this.input.readLine().trim();
            }
        }
    }

    private double parseIntoDouble(String value) {
        int bracketIndex;
        double returnVal = 0.0;
        if (value.charAt(0) == '.') {
            value = "0" + value;
        }
        if ((bracketIndex = value.indexOf("(")) != -1) {
            value = value.substring(0, bracketIndex);
        }
        try {
            returnVal = Double.parseDouble(value);
        }
        catch (Exception exception) {
            this.logger.error("Could not parse double string: " + value);
        }
        return returnVal;
    }

    private String extractFirstLetters(String value) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < value.length() && !Character.isDigit(value.charAt(i)); ++i) {
            result.append(value.charAt(i));
        }
        return result.toString();
    }

    public void close() throws IOException {
        this.input.close();
    }
}

