/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectReader;

public class GamessReader
extends DefaultChemObjectReader {
    public static final String FILE_FORMAT_NAME = "GAMESS log file";
    public static final boolean BOHR_UNIT = true;
    public static final double BOHR_TO_ANGSTROM = 0.529177249;
    public static final boolean ANGSTROM_UNIT = false;
    private BufferedReader input;

    public GamessReader(Reader inputReader) {
        this.input = new BufferedReader(inputReader);
    }

    public GamessReader() {
        this(new StringReader(""));
    }

    public boolean accepts(ChemObject object) {
        return object instanceof ChemFile;
    }

    public String getFormatName() {
        return FILE_FORMAT_NAME;
    }

    public void setReader(Reader reader) throws CDKException {
        this.input = this.input;
    }

    public boolean matches(int lineNumber, String line) {
        return line.indexOf("GAMESS") >= 0;
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemFile) {
            try {
                return this.readChemFile();
            }
            catch (IOException e) {
                return null;
            }
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private ChemFile readChemFile() throws IOException {
        ChemFile file = new ChemFile();
        ChemSequence sequence = new ChemSequence();
        ChemModel model = new ChemModel();
        SetOfMolecules moleculeSet = new SetOfMolecules();
        model.setSetOfMolecules(moleculeSet);
        sequence.addChemModel(model);
        file.addChemSequence(sequence);
        String currentReadLine = this.input.readLine();
        while (this.input.ready() && currentReadLine != null) {
            if (currentReadLine.indexOf("COORDINATES (BOHR)") >= 0) {
                this.input.readLine();
                moleculeSet.addMolecule(this.readCoordinates(true));
            } else if (currentReadLine.indexOf(" COORDINATES OF ALL ATOMS ARE (ANGS)") >= 0) {
                this.input.readLine();
                this.input.readLine();
                moleculeSet.addMolecule(this.readCoordinates(false));
            }
            currentReadLine = this.input.readLine();
        }
        return file;
    }

    private Molecule readCoordinates(boolean coordinatesUnits) throws IOException {
        String retrievedLineFromFile;
        double unitScaling = GamessReader.scalesCoordinatesUnits(coordinatesUnits);
        Molecule extractedMolecule = new Molecule();
        while (this.input.ready() && (retrievedLineFromFile = this.input.readLine()) != null && retrievedLineFromFile.trim().length() != 0) {
            String atomicSymbol;
            StreamTokenizer token = new StreamTokenizer(new StringReader(retrievedLineFromFile));
            token.nextToken();
            if (token.nextToken() == -2) {
                int atomicNumber = (int)token.nval;
                atomicSymbol = this.identifyAtomicSymbol(atomicNumber);
                if (atomicNumber == 0) {
                    continue;
                }
            } else {
                throw new IOException("Error reading coordinates");
            }
            double[] coordinates = new double[3];
            for (int i = 0; i < coordinates.length; ++i) {
                if (token.nextToken() != -2) {
                    throw new IOException("Error reading coordinates");
                }
                coordinates[i] = token.nval * unitScaling;
            }
            Atom atom = new Atom(atomicSymbol, new Point3d(coordinates[0], coordinates[1], coordinates[2]));
            extractedMolecule.addAtom(atom);
        }
        return extractedMolecule;
    }

    private String identifyAtomicSymbol(int atomicNumber) {
        String symbol;
        switch (atomicNumber) {
            case 1: {
                symbol = "H";
                break;
            }
            case 2: {
                symbol = "He";
                break;
            }
            case 3: {
                symbol = "Li";
                break;
            }
            case 4: {
                symbol = "Be";
                break;
            }
            case 5: {
                symbol = "B";
                break;
            }
            case 6: {
                symbol = "C";
                break;
            }
            case 7: {
                symbol = "N";
                break;
            }
            case 8: {
                symbol = "O";
                break;
            }
            case 9: {
                symbol = "F";
                break;
            }
            case 10: {
                symbol = "Ne";
                break;
            }
            case 11: {
                symbol = "Na";
                break;
            }
            case 12: {
                symbol = "Mg";
                break;
            }
            case 13: {
                symbol = "Al";
                break;
            }
            case 14: {
                symbol = "Si";
                break;
            }
            case 15: {
                symbol = "P";
                break;
            }
            case 16: {
                symbol = "S";
                break;
            }
            case 17: {
                symbol = "Cl";
                break;
            }
            case 18: {
                symbol = "Ar";
                break;
            }
            default: {
                symbol = null;
            }
        }
        return symbol;
    }

    private static double scalesCoordinatesUnits(boolean coordinatesUnits) {
        if (coordinatesUnits) {
            return 0.529177249;
        }
        return 1.0;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

