/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Locale;
import org.openscience.cdk.Atom;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.tools.LoggingTool;

public class MDLWriter
extends DefaultChemObjectWriter {
    private BufferedWriter writer;
    private LoggingTool logger;
    private IsotopeFactory isotopeFactory = null;

    public MDLWriter(FileOutputStream out) throws Exception {
        this(new BufferedWriter(new OutputStreamWriter(out)));
    }

    public String getFormatName() {
        return "MDL Mol/SDF";
    }

    public MDLWriter(Writer out) {
        this.writer = new BufferedWriter(out);
        this.logger = new LoggingTool(this.getClass().getName());
        try {
            this.isotopeFactory = IsotopeFactory.getInstance();
        }
        catch (Exception exception) {
            this.logger.error((Object)"Failed to initiate isotope factory: ", exception.getMessage());
            this.logger.debug(exception);
        }
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void write(ChemObject object) throws CDKException {
        if (object instanceof SetOfMolecules) {
            this.writeSetOfMolecules((SetOfMolecules)object);
        } else if (object instanceof Molecule) {
            try {
                boolean[] isVisible = new boolean[((Molecule)object).getAtomCount()];
                for (int i = 0; i < isVisible.length; ++i) {
                    isVisible[i] = true;
                }
                this.writeMolecule((Molecule)object, isVisible);
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage());
                this.logger.debug(ex);
            }
        } else {
            throw new CDKException("Only supported is writing of ChemFile and Molecule objects.");
        }
    }

    public ChemObject highestSupportedChemObject() {
        return new SetOfMolecules();
    }

    private void writeSetOfMolecules(SetOfMolecules som) {
        Molecule[] molecules = som.getMolecules();
        try {
            boolean[] isVisible = new boolean[molecules[0].getAtomCount()];
            for (int i = 0; i < isVisible.length; ++i) {
                isVisible[i] = true;
            }
            this.writeMolecule(molecules[0], isVisible);
        }
        catch (Exception exc) {
            // empty catch block
        }
        for (int i = 1; i <= som.getMoleculeCount() - 1; ++i) {
            try {
                this.writer.write("$$$$");
                this.writer.newLine();
                boolean[] isVisible = new boolean[molecules[i].getAtomCount()];
                for (int k = 0; k < isVisible.length; ++k) {
                    isVisible[k] = true;
                }
                this.writeMolecule(molecules[i], isVisible);
                continue;
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
    }

    public void writeMolecule(Molecule molecule) throws Exception {
        boolean[] isVisible = new boolean[molecule.getAtomCount()];
        for (int i = 0; i < isVisible.length; ++i) {
            isVisible[i] = true;
        }
        this.writeMolecule(molecule, isVisible);
    }

    public void writeMolecule(Molecule molecule, boolean[] isVisible) throws Exception {
        Atom atom;
        int i;
        String line = "";
        String title = (String)molecule.getProperty("Title");
        if (title == null) {
            title = "";
        }
        if (title.length() > 80) {
            title = title.substring(0, 80);
        }
        this.writer.write(title + "\n");
        this.writer.write("  CDK\n");
        String comment = (String)molecule.getProperty("Remark");
        if (comment == null) {
            comment = "";
        }
        if (comment.length() > 80) {
            comment = comment.substring(0, 80);
        }
        this.writer.write(comment + "\n");
        int upToWhichAtom = 0;
        for (int i2 = 0; i2 < isVisible.length; ++i2) {
            if (!isVisible[i2]) continue;
            ++upToWhichAtom;
        }
        line = line + this.formatMDLInt(upToWhichAtom, 3);
        int numberOfBonds = 0;
        if (upToWhichAtom < molecule.getAtomCount()) {
            for (int i3 = 0; i3 < molecule.getBondCount(); ++i3) {
                if (!isVisible[molecule.getAtomNumber(molecule.getBondAt(i3).getAtoms()[0])] || !isVisible[molecule.getAtomNumber(molecule.getBondAt(i3).getAtoms()[1])]) continue;
                ++numberOfBonds;
            }
        } else {
            numberOfBonds = molecule.getBondCount();
        }
        line = line + this.formatMDLInt(numberOfBonds, 3);
        line = line + "  0  0  0  0  0  0  0  0999 V2000\n";
        this.writer.write(line);
        Atom[] atoms = molecule.getAtoms();
        for (int f = 0; f < atoms.length; ++f) {
            if (!isVisible[f]) continue;
            Atom atom2 = atoms[f];
            line = "";
            if (atom2.getPoint3d() != null) {
                line = line + this.formatMDLFloat((float)atom2.getX3d());
                line = line + this.formatMDLFloat((float)atom2.getY3d());
                line = line + this.formatMDLFloat((float)atom2.getZ3d()) + " ";
            } else if (atom2.getPoint2d() != null) {
                line = line + this.formatMDLFloat((float)atom2.getX2d());
                line = line + this.formatMDLFloat((float)atom2.getY2d());
                line = line + "    0.0000 ";
            } else {
                line = line + this.formatMDLFloat(0.0f);
                line = line + this.formatMDLFloat(0.0f);
                line = line + this.formatMDLFloat(0.0f) + " ";
            }
            line = line + this.formatMDLString(molecule.getAtomAt(f).getSymbol(), 3);
            line = line + " 0  0  0  0  0  0  0  0  0  0  0  0";
            this.writer.write(line);
            this.writer.newLine();
        }
        Bond[] bonds = molecule.getBonds();
        for (int g = 0; g < bonds.length; ++g) {
            if (upToWhichAtom != molecule.getAtomCount() && (!isVisible[molecule.getAtomNumber(molecule.getBondAt(g).getAtoms()[0])] || !isVisible[molecule.getAtomNumber(molecule.getBondAt(g).getAtoms()[1])])) continue;
            Bond bond = bonds[g];
            if (bond.getAtoms().length != 2) {
                this.logger.warn("Skipping bond with more/less than two atoms: " + bond);
                continue;
            }
            if (bond.getStereo() == 2 || bond.getStereo() == -2) {
                line = this.formatMDLInt(molecule.getAtomNumber(bond.getAtomAt(1)) + 1, 3);
                line = line + this.formatMDLInt(molecule.getAtomNumber(bond.getAtomAt(0)) + 1, 3);
            } else {
                line = this.formatMDLInt(molecule.getAtomNumber(bond.getAtomAt(0)) + 1, 3);
                line = line + this.formatMDLInt(molecule.getAtomNumber(bond.getAtomAt(1)) + 1, 3);
            }
            double bondOrder = bond.getOrder();
            line = bondOrder == 1.5 ? line + this.formatMDLInt(4, 3) : line + this.formatMDLInt((int)bond.getOrder(), 3);
            line = line + "  ";
            switch (bond.getStereo()) {
                case 1: {
                    line = line + "1";
                    break;
                }
                case 2: {
                    line = line + "1";
                    break;
                }
                case -1: {
                    line = line + "6";
                    break;
                }
                case -2: {
                    line = line + "6";
                    break;
                }
                default: {
                    line = line + "0";
                }
            }
            line = line + "  0  0  0 ";
            this.writer.write(line);
            this.writer.newLine();
        }
        for (i = 0; i < atoms.length; ++i) {
            atom = atoms[i];
            int charge = atom.getFormalCharge();
            if (charge == 0) continue;
            this.writer.write("M  CHG  1 ");
            this.writer.write(this.formatMDLInt(i + 1, 3));
            this.writer.write(" ");
            this.writer.write(this.formatMDLInt(charge, 3));
            this.writer.newLine();
        }
        for (i = 0; i < atoms.length; ++i) {
            atom = atoms[i];
            if (atom instanceof PseudoAtom) continue;
            int atomicMass = atom.getMassNumber();
            int majorMass = this.isotopeFactory.getMajorIsotope(atom.getSymbol()).getMassNumber();
            if (atomicMass == 0 || atomicMass == majorMass) continue;
            this.writer.write("M  ISO  1 ");
            this.writer.write(this.formatMDLInt(i + 1, 3));
            this.writer.write(" ");
            this.writer.write(this.formatMDLInt(atomicMass - majorMass, 3));
            this.writer.newLine();
        }
        this.writer.write("M  END");
        this.writer.newLine();
        this.writer.flush();
    }

    private String formatMDLInt(int i, int l) {
        String s = "";
        String fs = "";
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setParseIntegerOnly(true);
        nf.setMinimumIntegerDigits(1);
        nf.setMaximumIntegerDigits(l);
        nf.setGroupingUsed(false);
        s = nf.format(i);
        l -= s.length();
        for (int f = 0; f < l; ++f) {
            fs = fs + " ";
        }
        fs = fs + s;
        return fs;
    }

    private String formatMDLFloat(float fl) {
        String s = "";
        String fs = "";
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setMinimumIntegerDigits(1);
        nf.setMaximumIntegerDigits(4);
        nf.setMinimumFractionDigits(4);
        nf.setMaximumFractionDigits(4);
        nf.setGroupingUsed(false);
        s = nf.format(fl);
        int l = 10 - s.length();
        for (int f = 0; f < l; ++f) {
            fs = fs + " ";
        }
        fs = fs + s;
        return fs;
    }

    private String formatMDLString(String s, int le) {
        if ((s = s.trim()).length() > le) {
            return s.substring(0, le);
        }
        int l = le - s.length();
        for (int f = 0; f < l; ++f) {
            s = s + " ";
        }
        return s;
    }
}

