/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.smiles.SmilesParser;

public class SMILESReader
extends DefaultChemObjectReader {
    private BufferedReader input = null;
    private SmilesParser sp = null;

    public SMILESReader(Reader input) {
        this.input = new BufferedReader(input);
        this.sp = new SmilesParser();
    }

    public SMILESReader() {
        this(new StringReader(""));
    }

    public String getFormatName() {
        return "SMILES";
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public boolean matches(int lineNumber, String line) {
        return false;
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof SetOfMolecules) {
            return this.readSetOfMolecules();
        }
        if (object instanceof ChemFile) {
            ChemFile file = new ChemFile();
            ChemSequence sequence = new ChemSequence();
            ChemModel chemModel = new ChemModel();
            chemModel.setSetOfMolecules(this.readSetOfMolecules());
            sequence.addChemModel(chemModel);
            file.addChemSequence(sequence);
            return file;
        }
        throw new CDKException("Only supported is reading of SetOfMolecules objects.");
    }

    private SetOfMolecules readSetOfMolecules() {
        SetOfMolecules som = new SetOfMolecules();
        try {
            String line = this.input.readLine();
            while (line != null) {
                try {
                    Molecule molecule = this.sp.parseSmiles(line);
                    som.addMolecule(molecule);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.input.ready()) {
                    line = this.input.readLine();
                    continue;
                }
                line = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return som;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

