/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import java.util.Hashtable;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Crystal;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.SetOfReactions;
import org.openscience.cdk.io.cml.cdopi.CDOAcceptedObjects;
import org.openscience.cdk.io.cml.cdopi.CDOInterface;
import org.openscience.cdk.tools.LoggingTool;

public class ChemFileCDO
extends ChemFile
implements CDOInterface {
    private AtomContainer currentMolecule;
    private SetOfMolecules currentSetOfMolecules;
    private ChemModel currentChemModel;
    private ChemSequence currentChemSequence;
    private SetOfReactions currentSetOfReactions = null;
    private Reaction currentReaction = null;
    private Atom currentAtom;
    private Crystal currentCrystal;
    private Hashtable atomEnumeration;
    private int numberOfAtoms = 0;
    private int bond_a1;
    private int bond_a2;
    private double bond_order;
    private int bond_stereo;
    private String bond_id;
    private double crystal_axis_x;
    private double crystal_axis_y;
    private double crystal_axis_z;
    protected LoggingTool logger = new LoggingTool(this.getClass().getName());

    public ChemFileCDO() {
        this.currentChemSequence = new ChemSequence();
        this.currentChemModel = new ChemModel();
        this.currentSetOfMolecules = new SetOfMolecules();
        this.currentMolecule = new Molecule();
        this.atomEnumeration = new Hashtable();
    }

    public void startDocument() {
        this.logger.info("New CDO Object");
        this.currentChemSequence = new ChemSequence();
        this.currentChemModel = new ChemModel();
        this.currentSetOfMolecules = new SetOfMolecules();
        this.currentMolecule = new Molecule();
        this.atomEnumeration = new Hashtable();
    }

    public void endDocument() {
        this.logger.debug("Closing document");
        if (this.currentSetOfReactions != null && this.currentSetOfReactions.getReactionCount() == 0 && this.currentReaction != null) {
            this.logger.debug("Adding reaction to SetOfReactions");
            this.currentSetOfReactions.addReaction(this.currentReaction);
        }
        if (this.currentSetOfReactions != null && this.currentChemModel.getSetOfReactions() == null) {
            this.logger.debug("Adding SOR to ChemModel");
            this.currentChemModel.setSetOfReactions(this.currentSetOfReactions);
        }
        if (this.currentSetOfMolecules != null && this.currentSetOfMolecules.getMoleculeCount() != 0) {
            this.logger.debug("Adding reaction to SetOfMolecules");
            this.currentChemModel.setSetOfMolecules(this.currentSetOfMolecules);
        }
        if (this.currentChemSequence.getChemModelCount() == 0) {
            this.logger.debug("Adding ChemModel to ChemSequence");
            this.currentChemSequence.addChemModel(this.currentChemModel);
        }
        if (this.getChemSequenceCount() == 0) {
            this.addChemSequence(this.currentChemSequence);
        }
        this.logger.info("End CDO Object");
        this.logger.info((Object)"Number of sequences:", this.getChemSequenceCount());
    }

    public void setDocumentProperty(String type, String value) {
    }

    public void startObject(String objectType) {
        this.logger.debug("START:" + objectType);
        if (objectType.equals("Molecule")) {
            if (this.currentChemModel == null) {
                this.currentChemModel = new ChemModel();
            }
            if (this.currentSetOfMolecules == null) {
                this.currentSetOfMolecules = new SetOfMolecules();
            }
            this.currentMolecule = new Molecule();
        } else if (objectType.equals("Atom")) {
            this.currentAtom = new Atom("H");
            this.logger.debug("Atom # " + this.numberOfAtoms);
            ++this.numberOfAtoms;
        } else if (objectType.equals("Bond")) {
            this.bond_id = null;
            this.bond_stereo = -99;
        } else if (objectType.equals("Animation")) {
            this.currentChemSequence = new ChemSequence();
        } else if (objectType.equals("Frame")) {
            this.currentChemModel = new ChemModel();
        } else if (objectType.equals("SetOfMolecules")) {
            this.currentSetOfMolecules = new SetOfMolecules();
            this.currentMolecule = new Molecule();
        } else if (objectType.equals("Crystal")) {
            this.currentMolecule = new Crystal(this.currentMolecule);
        } else if (objectType.equals("a-axis") || objectType.equals("b-axis") || objectType.equals("c-axis")) {
            this.crystal_axis_x = 0.0;
            this.crystal_axis_y = 0.0;
            this.crystal_axis_z = 0.0;
        } else if (objectType.equals("SetOfReactions")) {
            this.currentSetOfReactions = new SetOfReactions();
        } else if (objectType.equals("Reaction")) {
            if (this.currentSetOfReactions == null) {
                this.startObject("SetOfReactions");
            }
            this.currentReaction = new Reaction();
        } else if (objectType.equals("Reactant")) {
            if (this.currentReaction == null) {
                this.startObject("Reaction");
            }
            this.currentMolecule = new Molecule();
        } else if (objectType.equals("Product")) {
            if (this.currentReaction == null) {
                this.startObject("Reaction");
            }
            this.currentMolecule = new Molecule();
        }
    }

    public void endObject(String objectType) {
        this.logger.debug("END: " + objectType);
        if (objectType.equals("Molecule")) {
            if (this.currentMolecule instanceof Molecule) {
                this.logger.debug("Adding molecule to set");
                this.currentSetOfMolecules.addMolecule((Molecule)this.currentMolecule);
                this.logger.debug("#mols in set: " + this.currentSetOfMolecules.getMoleculeCount());
            } else if (this.currentMolecule instanceof Crystal) {
                this.logger.debug("Adding crystal to chemModel");
                this.currentChemModel.setCrystal((Crystal)this.currentMolecule);
                this.currentChemSequence.addChemModel(this.currentChemModel);
            }
        } else if (objectType.equals("SetOfMolecules")) {
            this.currentChemModel.setSetOfMolecules(this.currentSetOfMolecules);
            this.currentChemSequence.addChemModel(this.currentChemModel);
        } else if (!objectType.equals("Frame")) {
            if (objectType.equals("Animation")) {
                this.addChemSequence(this.currentChemSequence);
                this.logger.info("This file has " + this.getChemSequenceCount() + " sequence(s).");
            } else if (objectType.equals("Atom")) {
                this.currentMolecule.addAtom(this.currentAtom);
            } else if (objectType.equals("Bond")) {
                this.logger.debug("Bond(" + this.bond_id + "): " + this.bond_a1 + ", " + this.bond_a2 + ", " + this.bond_order);
                if (this.bond_a1 > this.currentMolecule.getAtomCount() || this.bond_a2 > this.currentMolecule.getAtomCount()) {
                    this.logger.error("Cannot add bond between at least one non-existant atom: " + this.bond_a1 + " and " + this.bond_a2);
                } else {
                    Atom a1 = this.currentMolecule.getAtomAt(this.bond_a1);
                    Atom a2 = this.currentMolecule.getAtomAt(this.bond_a2);
                    Bond b = new Bond(a1, a2, this.bond_order);
                    if (this.bond_id != null) {
                        b.setID(this.bond_id);
                    }
                    if (this.bond_stereo != -99) {
                        b.setStereo(this.bond_stereo);
                    }
                    if (this.bond_order == 1.5) {
                        b.setFlag(CDKConstants.ISAROMATIC, true);
                    }
                    this.currentMolecule.addBond(b);
                }
            } else if (objectType.equals("a-axis")) {
                if (this.currentMolecule instanceof Crystal) {
                    Crystal current = (Crystal)this.currentMolecule;
                    current.setA(this.crystal_axis_x, this.crystal_axis_y, this.crystal_axis_z);
                } else {
                    this.logger.warn("Current object is not a crystal");
                }
            } else if (objectType.equals("b-axis")) {
                if (this.currentMolecule instanceof Crystal) {
                    Crystal current = (Crystal)this.currentMolecule;
                    current.setB(this.crystal_axis_x, this.crystal_axis_y, this.crystal_axis_z);
                } else {
                    this.logger.warn("Current object is not a crystal");
                }
            } else if (objectType.equals("c-axis")) {
                if (this.currentMolecule instanceof Crystal) {
                    Crystal current = (Crystal)this.currentMolecule;
                    current.setC(this.crystal_axis_x, this.crystal_axis_y, this.crystal_axis_z);
                } else {
                    this.logger.warn("Current object is not a crystal");
                }
            } else if (objectType.equals("SetOfReactions")) {
                this.currentChemModel.setSetOfReactions(this.currentSetOfReactions);
                this.currentChemSequence.addChemModel(this.currentChemModel);
            } else if (objectType.equals("Reaction")) {
                this.logger.debug("Adding reaction to SOR");
                this.currentSetOfReactions.addReaction(this.currentReaction);
            } else if (objectType.equals("Reactant")) {
                this.currentReaction.addReactant((Molecule)this.currentMolecule);
            } else if (objectType.equals("Product")) {
                this.currentReaction.addProduct((Molecule)this.currentMolecule);
            } else if (objectType.equals("Crystal")) {
                this.logger.debug("Crystal: " + this.currentMolecule);
            }
        }
    }

    public void setObjectProperty(String objectType, String propertyType, String propertyValue) {
        this.logger.debug("objectType: " + objectType);
        this.logger.debug("propType: " + propertyType);
        this.logger.debug("property: " + propertyValue);
        if (objectType == null) {
            this.logger.error("Cannot add property for null object");
            return;
        }
        if (propertyType == null) {
            this.logger.error("Cannot add property for null property type");
            return;
        }
        if (propertyValue == null) {
            this.logger.warn("Will not add null property");
            return;
        }
        if (objectType.equals("Molecule")) {
            if (propertyType.equals("id")) {
                this.currentMolecule.setID(propertyValue);
            }
        } else if (objectType.equals("PseudoAtom")) {
            if (propertyType.equals("label")) {
                if (!(this.currentAtom instanceof PseudoAtom)) {
                    this.currentAtom = new PseudoAtom(this.currentAtom);
                }
                ((PseudoAtom)this.currentAtom).setLabel(propertyValue);
            }
        } else if (objectType.equals("Atom")) {
            if (propertyType.equals("type")) {
                if (propertyValue.equals("R") && !(this.currentAtom instanceof PseudoAtom)) {
                    this.currentAtom = new PseudoAtom(this.currentAtom);
                }
                this.currentAtom.setSymbol(propertyValue);
            } else if (propertyType.equals("x2")) {
                this.currentAtom.setX2d(new Double(propertyValue));
            } else if (propertyType.equals("y2")) {
                this.currentAtom.setY2d(new Double(propertyValue));
            } else if (propertyType.equals("x3")) {
                this.currentAtom.setX3d(new Double(propertyValue));
            } else if (propertyType.equals("y3")) {
                this.currentAtom.setY3d(new Double(propertyValue));
            } else if (propertyType.equals("z3")) {
                this.currentAtom.setZ3d(new Double(propertyValue));
            } else if (propertyType.equals("xFract")) {
                this.currentAtom.setFractX3d(new Double(propertyValue));
            } else if (propertyType.equals("yFract")) {
                this.currentAtom.setFractY3d(new Double(propertyValue));
            } else if (propertyType.equals("zFract")) {
                this.currentAtom.setFractZ3d(new Double(propertyValue));
            } else if (propertyType.equals("formalCharge")) {
                this.currentAtom.setFormalCharge(new Integer(propertyValue));
            } else if (propertyType.equals("charge")) {
                this.currentAtom.setCharge(new Double(propertyValue));
            } else if (propertyType.equals("hydrogenCount")) {
                this.currentAtom.setHydrogenCount(new Integer(propertyValue));
            } else if (propertyType.equals("dictRef")) {
                this.currentAtom.setProperty("org.openscience.cdk.dict", propertyValue);
            } else if (propertyType.equals("atomicNumber")) {
                this.currentAtom.setAtomicNumber(Integer.parseInt(propertyValue));
            } else if (propertyType.equals("massNumber")) {
                this.currentAtom.setMassNumber(Integer.parseInt(propertyValue));
            } else if (propertyType.equals("id")) {
                this.logger.debug((Object)"id: ", propertyValue);
                this.currentAtom.setID(propertyValue);
                this.atomEnumeration.put(propertyValue, new Integer(this.numberOfAtoms));
            }
        } else if (objectType.equals("Bond")) {
            if (propertyType.equals("atom1")) {
                this.bond_a1 = new Integer(propertyValue);
            } else if (propertyType.equals("atom2")) {
                this.bond_a2 = new Integer(propertyValue);
            } else if (propertyType.equals("id")) {
                this.logger.debug("id: " + propertyValue);
                this.bond_id = propertyValue;
            } else if (propertyType.equals("order")) {
                try {
                    this.bond_order = Double.parseDouble(propertyValue);
                }
                catch (Exception e) {
                    this.logger.error("Cannot convert to double: " + propertyValue);
                    this.bond_order = 1.0;
                }
            } else if (propertyType.equals("stereo")) {
                if (propertyValue.equals("H")) {
                    this.bond_stereo = -1;
                } else if (propertyValue.equals("W")) {
                    this.bond_stereo = 1;
                }
            }
        } else if (objectType.equals("Reaction")) {
            if (propertyType.equals("id")) {
                this.currentReaction.setID(propertyValue);
            }
        } else if (objectType.equals("SetOfReactions")) {
            if (propertyType.equals("id")) {
                this.currentSetOfReactions.setID(propertyValue);
            }
        } else if (objectType.equals("Reactant")) {
            if (propertyType.equals("id")) {
                this.currentMolecule.setID(propertyValue);
            }
        } else if (objectType.equals("Product")) {
            if (propertyType.equals("id")) {
                this.currentMolecule.setID(propertyValue);
            }
        } else if (objectType.equals("Crystal")) {
            if (this.currentMolecule instanceof Crystal) {
                Crystal current = (Crystal)this.currentMolecule;
                if (propertyType.equals("spacegroup")) {
                    this.logger.debug("Setting crystal spacegroup to: " + propertyValue);
                    current.setSpaceGroup(propertyValue);
                } else if (propertyType.equals("z")) {
                    try {
                        this.logger.debug("Setting z to: " + propertyValue);
                        current.setZ(Integer.parseInt(propertyValue));
                    }
                    catch (NumberFormatException exception) {
                        this.logger.error("Error in format of Z value");
                    }
                }
            } else {
                this.logger.warn("Cannot add crystal cell parameters to a non Crystal class!");
            }
        } else if (objectType.equals("a-axis") || objectType.equals("b-axis") || objectType.equals("c-axis")) {
            if (this.currentMolecule instanceof Crystal) {
                Crystal current = (Crystal)this.currentMolecule;
                this.logger.debug("Setting axis (" + objectType + "): " + propertyValue);
                if (propertyType.equals("x")) {
                    this.crystal_axis_x = Double.parseDouble(propertyValue);
                } else if (propertyType.equals("y")) {
                    this.crystal_axis_y = Double.parseDouble(propertyValue);
                } else if (propertyType.equals("z")) {
                    this.crystal_axis_z = Double.parseDouble(propertyValue);
                }
            } else {
                this.logger.warn("Cannot add crystal cell parameters to a non Crystal class!");
            }
        }
        this.logger.debug("Object property set...");
    }

    public CDOAcceptedObjects acceptObjects() {
        CDOAcceptedObjects objects = new CDOAcceptedObjects();
        objects.add("Molecule");
        objects.add("Fragment");
        objects.add("Atom");
        objects.add("Bond");
        objects.add("Animation");
        objects.add("Frame");
        objects.add("Crystal");
        objects.add("a-axis");
        objects.add("b-axis");
        objects.add("c-axis");
        objects.add("SetOfReactions");
        objects.add("Reactions");
        objects.add("Reactant");
        objects.add("Product");
        return objects;
    }
}

