/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.isotopes;

import java.util.Vector;
import org.openscience.cdk.Isotope;
import org.openscience.cdk.tools.LoggingTool;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class IsotopeHandler
extends DefaultHandler {
    private LoggingTool logger = new LoggingTool(this);
    private String currentChars;
    private Vector isotopes;
    private Isotope workingIsotope;
    private String currentElement;
    private String dictRef;

    public Vector getIsotopes() {
        return this.isotopes;
    }

    public void startDocument() {
        this.isotopes = new Vector();
    }

    public void endElement(String uri, String local, String raw) {
        this.logger.debug("end element: " + raw);
        if ("isotope".equals(local)) {
            if (this.workingIsotope != null) {
                this.isotopes.addElement(this.workingIsotope);
            }
            this.workingIsotope = null;
        } else if ("isotopeList".equals(local)) {
            this.currentElement = null;
        } else if ("abundance".equals(local)) {
            try {
                this.workingIsotope.setNaturalAbundance(Double.parseDouble(this.currentChars));
            }
            catch (NumberFormatException exception) {
                this.logger.error((Object)"The abundance value is incorrect: ", this.currentChars);
                this.logger.debug(exception);
            }
        } else if ("scalar".equals(local)) {
            try {
                if ("cdk:exactMass".equals(this.dictRef)) {
                    this.workingIsotope.setExactMass(Double.parseDouble(this.currentChars));
                } else if ("cdk:atomicNumber".equals(this.dictRef)) {
                    this.workingIsotope.setAtomicNumber(Integer.parseInt(this.currentChars));
                }
            }
            catch (NumberFormatException exception) {
                this.logger.error("The ", this.dictRef, " value is incorrect: ", this.currentChars);
                this.logger.debug(exception);
            }
        }
    }

    public void startElement(String uri, String local, String raw, Attributes atts) {
        block8: {
            block9: {
                block7: {
                    this.currentChars = "";
                    this.dictRef = "";
                    this.logger.debug((Object)"startElement: ", raw);
                    this.logger.debug((Object)"uri: ", uri);
                    this.logger.debug((Object)"local: ", local);
                    this.logger.debug((Object)"raw: ", raw);
                    if (!"isotope".equals(local)) break block7;
                    this.workingIsotope = new Isotope(this.currentElement);
                    for (int i = 0; i < atts.getLength(); ++i) {
                        try {
                            if ("id".equals(atts.getQName(i))) {
                                this.workingIsotope.setID(atts.getValue(i));
                                continue;
                            }
                            if ("isotopeNumber".equals(atts.getQName(i))) {
                                this.workingIsotope.setMassNumber(Integer.parseInt(atts.getValue(i)));
                                continue;
                            }
                            if (!"elementType".equals(atts.getQName(i))) continue;
                            this.workingIsotope.setSymbol(atts.getValue(i));
                            continue;
                        }
                        catch (NumberFormatException exception) {
                            this.logger.error("Value of isotope@", atts.getQName(i), " is not as expected.");
                            this.logger.debug(exception);
                        }
                    }
                    break block8;
                }
                if (!"isotopeList".equals(local)) break block9;
                for (int i = 0; i < atts.getLength(); ++i) {
                    if (!"id".equals(atts.getQName(i))) continue;
                    this.currentElement = atts.getValue(i);
                }
                break block8;
            }
            if ("abundance".equals(local) || !"scalar".equals(local)) break block8;
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!"dictRef".equals(atts.getQName(i))) continue;
                this.dictRef = atts.getValue(i);
            }
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.currentChars = this.currentChars + new String(ch, start, length);
    }
}

