/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.dadml.filereaders;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openscience.dadml.DBLIST;
import org.openscience.dadml.handlers.DBLISTHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import sun.misc.BASE64Encoder;

public class DBLISTFileReader {
    private XMLReader parser;

    public DBLIST read(String url) throws Exception {
        return this.read(new URL(url).openStream());
    }

    public DBLIST read(String url, String proxyUser, String proxyPwd) throws Exception {
        URLConnection connection = new URL(url).openConnection();
        String password = proxyUser + ":" + proxyPwd;
        String encodedPassword = "Basic " + new BASE64Encoder().encode(password.getBytes());
        connection.setRequestProperty("Proxy-Authorization", encodedPassword);
        return this.read(connection.getInputStream());
    }

    private DBLIST read(InputStream is) throws Exception {
        this.initReader();
        DBLISTHandler handler = new DBLISTHandler();
        this.parser.setContentHandler(handler);
        this.parser.parse(new InputSource(is));
        DBLIST dblist = handler.returnDBLIST();
        return dblist;
    }

    private void initReader() {
        boolean success = false;
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
                success = true;
            }
            catch (Exception e) {
                System.out.println("Could not instantiate Aelfred2 XML reader:" + e.getMessage());
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
                success = true;
            }
            catch (Exception e) {
                System.out.println("Could not instantiate Xerces XML reader:" + e.getMessage());
            }
        }
        if (!success) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                this.parser = saxParser.getXMLReader();
                success = true;
            }
            catch (Exception e) {
                System.out.println("Could not instantiate JAXP/SAX XML reader:" + e.getMessage());
            }
        }
        if (!success) {
            System.out.println("Could not instantiate an XML parser!");
        }
    }
}

