/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import org.openscience.jmol.app.CommandHistory;
import org.openscience.jmol.app.ConsoleDocument;
import org.openscience.jmol.app.EnterListener;

class ConsoleTextPane
extends JTextPane {
    private CommandHistory commandHistory = new CommandHistory(20);
    ConsoleDocument consoleDoc = (ConsoleDocument)this.getDocument();
    EnterListener enterListener;

    ConsoleTextPane(EnterListener enterListener) {
        super(new ConsoleDocument());
        this.consoleDoc.setConsoleTextPane(this);
        this.enterListener = enterListener;
    }

    public String getCommandString() {
        String cmd = this.consoleDoc.getCommandString();
        this.commandHistory.addCommand(cmd);
        return cmd;
    }

    public void setPrompt() {
        this.consoleDoc.setPrompt();
    }

    public void appendNewline() {
        this.consoleDoc.appendNewline();
    }

    public void outputError(String strError) {
        this.consoleDoc.outputError(strError);
    }

    public void outputErrorForeground(String strError) {
        this.consoleDoc.outputErrorForeground(strError);
    }

    public void outputEcho(String strEcho) {
        this.consoleDoc.outputEcho(strEcho);
    }

    public void outputStatus(String strStatus) {
        this.consoleDoc.outputStatus(strStatus);
    }

    public void enterPressed() {
        if (this.enterListener != null) {
            this.enterListener.enterPressed();
        }
    }

    protected void processKeyEvent(KeyEvent ke) {
        if (ke.getKeyCode() == 38 && ke.getID() == 401 && !ke.isControlDown()) {
            this.recallCommand(true);
        } else if (ke.getKeyCode() == 40 && ke.getID() == 401 && !ke.isControlDown()) {
            this.recallCommand(false);
        } else if ((ke.getKeyCode() == 40 || ke.getKeyCode() == 38) && ke.getID() == 401 && ke.isControlDown()) {
            super.processKeyEvent(new KeyEvent((Component)ke.getSource(), ke.getID(), ke.getWhen(), 0, ke.getKeyCode(), ke.getKeyChar(), ke.getKeyLocation()));
        } else {
            super.processKeyEvent(ke);
        }
    }

    private final void recallCommand(boolean up) {
        String cmd = up ? this.commandHistory.getCommandUp() : this.commandHistory.getCommandDown();
        try {
            this.consoleDoc.replaceCommand(cmd);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

