/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.openscience.jmol.app.JmolResourceHandler;

public class FileTyper
extends JPanel
implements PropertyChangeListener,
ItemListener {
    private JCheckBox useFileExtensionCheckBox;
    private JLabel fileTypeLabel;
    private JComboBox fileTypeComboBox;
    private boolean useFileExtension = true;
    private String[] choices = new String[]{JmolResourceHandler.getStringX("FileTyper.XYZ"), JmolResourceHandler.getStringX("FileTyper.PDB"), JmolResourceHandler.getStringX("FileTyper.CML")};
    private int defaultTypeIndex = 0;
    private String fileType = this.choices[this.defaultTypeIndex];

    public FileTyper() {
        this.setLayout(new BorderLayout());
        JPanel fileTypePanel = new JPanel();
        fileTypePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        fileTypePanel.setLayout(new GridBagLayout());
        JLabel fillerLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        fileTypePanel.add((Component)fillerLabel, gridBagConstraints);
        this.useFileExtensionCheckBox = new JCheckBox(JmolResourceHandler.getStringX("FileTyper.useFileExtensionCheckBox"), this.useFileExtension);
        this.useFileExtensionCheckBox.addItemListener(this);
        String mnemonic = JmolResourceHandler.getStringX("FileTyper.useFileExtensionMnemonic");
        if (mnemonic != null && mnemonic.length() > 0) {
            this.useFileExtensionCheckBox.setMnemonic(mnemonic.charAt(0));
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        fileTypePanel.add((Component)this.useFileExtensionCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.fileTypeLabel = new JLabel(JmolResourceHandler.getStringX("FileTyper.fileTypeLabel"));
        this.fileTypeLabel.setForeground(Color.black);
        fileTypePanel.add((Component)this.fileTypeLabel, gridBagConstraints);
        this.fileTypeComboBox = new JComboBox<String>(this.choices);
        gridBagConstraints.gridwidth = 0;
        fileTypePanel.add((Component)this.fileTypeComboBox, gridBagConstraints);
        this.fileTypeComboBox.setSelectedIndex(this.defaultTypeIndex);
        this.fileTypeComboBox.addItemListener(this);
        this.add((Component)fileTypePanel, "Center");
        this.setUseFileExtension(this.useFileExtension);
    }

    public String getType() {
        return this.fileType;
    }

    private void setUseFileExtension(boolean value) {
        this.useFileExtension = value;
        this.fileTypeLabel.setEnabled(!this.useFileExtension);
        this.fileTypeComboBox.setEnabled(!this.useFileExtension);
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getSource() == this.useFileExtensionCheckBox) {
            if (event.getStateChange() == 2) {
                this.setUseFileExtension(false);
            } else {
                this.setUseFileExtension(true);
            }
        } else if (event.getSource() == this.fileTypeComboBox) {
            this.fileType = (String)this.fileTypeComboBox.getSelectedItem();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if (this.useFileExtension && property.equals("SelectedFileChangedProperty")) {
            File file = (File)event.getNewValue();
            String fileName = file.toString().toLowerCase();
            if (fileName.endsWith("xyz")) {
                this.fileTypeComboBox.setSelectedIndex(0);
            } else if (fileName.endsWith("pdb")) {
                this.fileTypeComboBox.setSelectedIndex(1);
            } else if (fileName.endsWith("cml")) {
                this.fileTypeComboBox.setSelectedIndex(2);
            } else {
                this.fileTypeComboBox.setSelectedIndex(0);
            }
        }
    }
}

