/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer;

import java.lang.reflect.Array;

public final class Util {
    public static Object ensureLength(Object array, int minimumLength) {
        if (array != null && Array.getLength(array) >= minimumLength) {
            return array;
        }
        return Util.setLength(array, minimumLength);
    }

    public static String[] ensureLength(String[] array, int minimumLength) {
        if (array != null && array.length >= minimumLength) {
            return array;
        }
        return Util.setLength(array, minimumLength);
    }

    public static short[] ensureLength(short[] array, int minimumLength) {
        if (array != null && array.length >= minimumLength) {
            return array;
        }
        return Util.setLength(array, minimumLength);
    }

    public static byte[] ensureLength(byte[] array, int minimumLength) {
        if (array != null && array.length >= minimumLength) {
            return array;
        }
        return Util.setLength(array, minimumLength);
    }

    public static Object doubleLength(Object array) {
        return Util.setLength(array, 2 * Array.getLength(array));
    }

    public static String[] doubleLength(String[] array) {
        return Util.setLength(array, 2 * array.length);
    }

    public static float[] doubleLength(float[] array) {
        return Util.setLength(array, array == null ? 16 : 2 * array.length);
    }

    public static int[] doubleLength(int[] array) {
        return Util.setLength(array, array == null ? 16 : 2 * array.length);
    }

    public static short[] doubleLength(short[] array) {
        return Util.setLength(array, array == null ? 16 : 2 * array.length);
    }

    public static byte[] doubleLength(byte[] array) {
        return Util.setLength(array, array == null ? 16 : 2 * array.length);
    }

    public static Object setLength(Object array, int newLength) {
        Object t = Array.newInstance(array.getClass().getComponentType(), newLength);
        int oldLength = Array.getLength(array);
        System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        return t;
    }

    public static String[] setLength(String[] array, int newLength) {
        String[] t = new String[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static float[] setLength(float[] array, int newLength) {
        float[] t = new float[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static int[] setLength(int[] array, int newLength) {
        int[] t = new int[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static short[] setLength(short[] array, int newLength) {
        short[] t = new short[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static byte[] setLength(byte[] array, int newLength) {
        byte[] t = new byte[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }
}

