/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

public final class Bspt {
    private static final int leafCountMax = 4;
    private static final int stackDepth = 64;
    int dimMax;
    Element eleRoot;

    Bspt(int dimMax) {
        this.dimMax = dimMax;
        this.eleRoot = new Leaf();
    }

    void addTuple(Tuple tuple) {
        if (!this.eleRoot.addTuple(tuple)) {
            this.eleRoot = new Node(0, this.dimMax, (Leaf)this.eleRoot);
            if (!this.eleRoot.addTuple(tuple)) {
                System.out.println("Bspt.addTuple() failed");
            }
        }
    }

    SphereIterator allocateSphereIterator() {
        return new SphereIterator();
    }

    static class Leaf
    implements Element {
        int count = 0;
        Tuple[] tuples = new Tuple[4];

        Leaf() {
        }

        Leaf(Leaf leaf, int dim, float splitValue) {
            this();
            Tuple tuple;
            int i = 4;
            while (--i >= 0) {
                tuple = leaf.tuples[i];
                float value = tuple.getDimensionValue(dim);
                if (!(value > splitValue)) continue;
                leaf.tuples[i] = null;
                this.tuples[this.count++] = tuple;
            }
            i = 4;
            while (--i >= 0) {
                tuple = leaf.tuples[i];
                if (tuple == null || tuple.getDimensionValue(dim) != splitValue || this.count >= 2) continue;
                leaf.tuples[i] = null;
                this.tuples[this.count++] = tuple;
            }
            int dest = 0;
            for (int src = 0; src < 4; ++src) {
                if (leaf.tuples[src] == null) continue;
                leaf.tuples[dest++] = leaf.tuples[src];
            }
            leaf.count = dest;
            if (this.count == 0 || leaf.count == 0) {
                throw new NullPointerException("Bspt leaf splitting error");
            }
        }

        float getSplitValue(int dim) {
            if (this.count != 4) {
                throw new NullPointerException("Bspt leaf splitting too soon");
            }
            return (this.tuples[0].getDimensionValue(dim) + this.tuples[1].getDimensionValue(dim)) / 2.0f;
        }

        public boolean addTuple(Tuple tuple) {
            if (this.count == 4) {
                return false;
            }
            this.tuples[this.count++] = tuple;
            return true;
        }

        public boolean isLeafWithSpace() {
            return this.count < 4;
        }
    }

    static class Node
    implements Element {
        Element eleLE;
        int dim;
        int dimMax;
        float splitValue;
        Element eleGE;

        Node(int dim, int dimMax, Leaf leafLE) {
            this.eleLE = leafLE;
            this.dim = dim;
            this.dimMax = dimMax;
            this.splitValue = leafLE.getSplitValue(dim);
            this.eleGE = new Leaf(leafLE, dim, this.splitValue);
        }

        public boolean addTuple(Tuple tuple) {
            if (tuple.getDimensionValue(this.dim) < this.splitValue) {
                if (this.eleLE.addTuple(tuple)) {
                    return true;
                }
                this.eleLE = new Node((this.dim + 1) % this.dimMax, this.dimMax, (Leaf)this.eleLE);
                return this.eleLE.addTuple(tuple);
            }
            if (tuple.getDimensionValue(this.dim) > this.splitValue) {
                if (this.eleGE.addTuple(tuple)) {
                    return true;
                }
                this.eleGE = new Node((this.dim + 1) % this.dimMax, this.dimMax, (Leaf)this.eleGE);
                return this.eleGE.addTuple(tuple);
            }
            if (this.eleLE.isLeafWithSpace()) {
                this.eleLE.addTuple(tuple);
            } else if (this.eleGE.isLeafWithSpace()) {
                this.eleGE.addTuple(tuple);
            } else if (this.eleLE instanceof Node) {
                this.eleLE.addTuple(tuple);
            } else if (this.eleGE instanceof Node) {
                this.eleGE.addTuple(tuple);
            } else {
                this.eleLE = new Node((this.dim + 1) % this.dimMax, this.dimMax, (Leaf)this.eleLE);
                return this.eleLE.addTuple(tuple);
            }
            return true;
        }

        public boolean isLeafWithSpace() {
            return false;
        }
    }

    static interface Element {
        public boolean addTuple(Tuple var1);

        public boolean isLeafWithSpace();
    }

    static interface Tuple {
        public float getDimensionValue(int var1);
    }

    class SphereIterator {
        Node[] stack;
        int sp;
        int leafIndex;
        Leaf leaf;
        Tuple center;
        float radius;
        float[] centerValues;
        float radius2;
        float foundDistance2;
        boolean tHemisphere;

        SphereIterator() {
            this.centerValues = new float[Bspt.this.dimMax];
            this.stack = new Node[64];
        }

        void initialize(Tuple center, float radius) {
            this.center = center;
            this.radius = radius;
            this.radius2 = radius * radius;
            this.tHemisphere = false;
            int dim = Bspt.this.dimMax;
            while (--dim >= 0) {
                this.centerValues[dim] = center.getDimensionValue(dim);
            }
            this.sp = 0;
            Element ele = Bspt.this.eleRoot;
            while (ele instanceof Node) {
                Node node = (Node)ele;
                if (this.centerValues[node.dim] - radius <= node.splitValue) {
                    if (this.sp == 64) {
                        System.out.println("Bspt.SphereIterator tree stack overflow");
                    }
                    this.stack[this.sp++] = node;
                    ele = node.eleLE;
                    continue;
                }
                ele = node.eleGE;
            }
            this.leaf = (Leaf)ele;
            this.leafIndex = 0;
        }

        void initializeHemisphere(Tuple center, float radius) {
            this.initialize(center, radius);
            this.tHemisphere = true;
        }

        void release() {
            int i = 64;
            while (--i >= 0) {
                this.stack[i] = null;
            }
        }

        private boolean isWithin(Tuple t) {
            float distT = t.getDimensionValue(0) - this.centerValues[0];
            if (this.tHemisphere && distT < 0.0f) {
                return false;
            }
            float dist2 = distT * distT;
            if (dist2 > this.radius2) {
                return false;
            }
            int dim = Bspt.this.dimMax - 1;
            do {
                if (!((dist2 += (distT = t.getDimensionValue(dim) - this.centerValues[dim]) * distT) > this.radius2)) continue;
                return false;
            } while (--dim > 0);
            this.foundDistance2 = dist2;
            return true;
        }

        boolean hasMoreElements() {
            while (true) {
                if (this.leafIndex < this.leaf.count) {
                    if (this.isWithin(this.leaf.tuples[this.leafIndex])) {
                        return true;
                    }
                    ++this.leafIndex;
                    continue;
                }
                if (this.sp == 0) {
                    return false;
                }
                Element ele = this.stack[--this.sp];
                while (ele instanceof Node) {
                    Node node = ele;
                    if (this.centerValues[node.dim] + this.radius < node.splitValue) {
                        if (this.sp == 0) {
                            return false;
                        }
                        ele = this.stack[--this.sp];
                        continue;
                    }
                    ele = node.eleGE;
                    while (ele instanceof Node) {
                        Element nodeLeft = ele;
                        this.stack[this.sp++] = nodeLeft;
                        ele = nodeLeft.eleLE;
                    }
                }
                this.leaf = (Leaf)ele;
                this.leafIndex = 0;
            }
        }

        Object nextElement() {
            return this.leaf.tuples[this.leafIndex++];
        }

        float foundDistance2() {
            return this.foundDistance2;
        }
    }
}

