/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import java.awt.FontMetrics;
import java.util.BitSet;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.openscience.jmol.viewer.datamodel.Shape;

public class Echo
extends Shape {
    private static final int LEFT = 0;
    private static final int CENTER = 1;
    private static final int RIGHT = 2;
    private static final int TOP = 0;
    private static final int BOTTOM = 1;
    private static final int MIDDLE = 2;
    private static final String FONTFACE = "Serif";
    private static final int FONTSIZE = 20;
    private static final short COLOR = 7;
    Text topText;
    Text middleText;
    Text bottomText;
    Text currentText;

    void initShape() {
    }

    void setProperty(String propertyName, Object value, BitSet bsSelected) {
        if ("color" == propertyName) {
            if (this.currentText != null) {
                this.currentText.colix = this.g3d.getColix(value);
            }
            return;
        }
        if ("bgcolor" == propertyName) {
            if (this.currentText != null) {
                this.currentText.bgcolix = value == null ? (short)0 : this.g3d.getColix(value);
            }
            return;
        }
        if ("font" == propertyName) {
            if (this.currentText != null) {
                this.currentText.font3d = (Font3D)value;
                this.currentText.recalc();
            }
            return;
        }
        if ("echo" == propertyName && this.currentText != null) {
            this.currentText.text = (String)value;
            this.currentText.recalc();
        }
        if ("off" == propertyName) {
            this.currentText = null;
            if (this.topText != null) {
                this.topText.text = null;
            }
            if (this.middleText != null) {
                this.middleText.text = null;
            }
            if (this.bottomText != null) {
                this.bottomText.text = null;
            }
        }
        if ("target" == propertyName) {
            String target = ((String)value).intern();
            if ("top" == target) {
                if (this.topText == null) {
                    this.topText = new Text(0, 1, this.g3d.getFont3D(FONTFACE, 20), 7);
                }
                this.currentText = this.topText;
                return;
            }
            if ("middle" == target) {
                if (this.middleText == null) {
                    this.middleText = new Text(2, 1, this.g3d.getFont3D(FONTFACE, 20), 7);
                }
                this.currentText = this.middleText;
                return;
            }
            if ("bottom" == target) {
                if (this.bottomText == null) {
                    this.bottomText = new Text(1, 0, this.g3d.getFont3D(FONTFACE, 20), 7);
                }
                this.currentText = this.bottomText;
                return;
            }
            if ("none" == target) {
                this.currentText = null;
                return;
            }
            System.out.println("unrecognized target:" + target);
            return;
        }
        if ("align" == propertyName) {
            if (this.currentText == null) {
                return;
            }
            String align = ((String)value).intern();
            if ("left" == align) {
                this.currentText.align = 0;
                return;
            }
            if ("center" == align) {
                this.currentText.align = 1;
                return;
            }
            if ("right" == align) {
                this.currentText.align = 2;
                return;
            }
            System.out.println("unrecognized align:" + align);
            return;
        }
    }

    class Text {
        String text;
        int align;
        int valign;
        Font3D font3d;
        short colix;
        short bgcolix;
        int width;
        int ascent;
        int descent;

        Text(int valign, int align, Font3D font3d, short colix) {
            this.align = align;
            this.valign = valign;
            this.font3d = font3d;
            this.colix = colix;
        }

        void recalc() {
            if (this.text == null || this.text.length() == 0) {
                this.text = null;
                return;
            }
            FontMetrics fm = this.font3d.fontMetrics;
            this.width = fm.stringWidth(this.text);
            this.descent = fm.getDescent();
            this.ascent = fm.getAscent();
        }

        void render(Graphics3D g3d) {
            if (this.text == null) {
                return;
            }
            int x = g3d.width - this.width - 1;
            if (this.align == 1) {
                x /= 2;
            } else if (this.align == 0) {
                x = 0;
            }
            int y = this.valign == 0 ? this.ascent : (this.valign == 2 ? g3d.height / 2 : g3d.height - this.descent - 1);
            g3d.setFont(this.font3d);
            g3d.drawString(this.text, this.colix, x, y, 0);
        }
    }
}

