/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import javax.vecmath.Point3f;
import org.openscience.jmol.viewer.datamodel.Atom;
import org.openscience.jmol.viewer.datamodel.Chain;
import org.openscience.jmol.viewer.datamodel.Closest;
import org.openscience.jmol.viewer.datamodel.Monomer;
import org.openscience.jmol.viewer.datamodel.PhosphorusMonomer;

public class NucleicMonomer
extends PhosphorusMonomer {
    static final byte[] interestingNucleicAtomIDs = new byte[]{-13, 69, -51, 68, 69, 64, 65, 66, 67, -71, -72, -73, -74, -80, -79, -75, -78, -77, -76, -81, -46, -47, 5, -60, 9, -13};
    boolean hasRnaO2Prime;
    boolean isPurine;
    boolean isPyrimidine;
    static final byte[] ring5OffsetIndexes = new byte[]{3, 10, 11, 12, 8};

    static Monomer validateAndAllocate(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, int[] specialAtomIndexes, Atom[] atoms) {
        byte[] offsets = NucleicMonomer.scanForOffsets(firstAtomIndex, specialAtomIndexes, interestingNucleicAtomIDs);
        if (offsets == null) {
            return null;
        }
        NucleicMonomer nucleicMonomer = new NucleicMonomer(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
        return nucleicMonomer;
    }

    NucleicMonomer(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, byte[] offsets) {
        super(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
        if (offsets[0] == -1) {
            byte leadOffset = offsets[20];
            if (leadOffset == -1) {
                leadOffset = offsets[21];
            }
            if (leadOffset == -1) {
                leadOffset = offsets[22];
            }
            offsets[0] = leadOffset;
        }
        this.hasRnaO2Prime = offsets[2] != -1;
        this.isPyrimidine = offsets[9] != -1;
        this.isPurine = offsets[10] != -1 && offsets[11] != -1 && offsets[12] != -1;
    }

    boolean isNucleicMonomer() {
        return true;
    }

    public boolean isDna() {
        return !this.hasRnaO2Prime;
    }

    public boolean isRna() {
        return this.hasRnaO2Prime;
    }

    public boolean isPurine() {
        return this.isPurine;
    }

    public boolean isPyrimidine() {
        return this.isPyrimidine;
    }

    boolean isGuanine() {
        return this.offsets[18] != -1;
    }

    byte getProteinStructureType() {
        return this.hasRnaO2Prime ? (byte)5 : 4;
    }

    Atom getN1() {
        return this.getAtomFromOffsetIndex(5);
    }

    Atom getN3() {
        return this.getAtomFromOffsetIndex(7);
    }

    Atom getN2() {
        return this.getAtomFromOffsetIndex(18);
    }

    Atom getO2() {
        return this.getAtomFromOffsetIndex(9);
    }

    Atom getO6() {
        return this.getAtomFromOffsetIndex(14);
    }

    Atom getN4() {
        return this.getAtomFromOffsetIndex(15);
    }

    Atom getN6() {
        return this.getAtomFromOffsetIndex(17);
    }

    Atom getO4() {
        return this.getAtomFromOffsetIndex(13);
    }

    Atom getAtom(byte specialAtomID) {
        return this.getSpecialAtom(interestingNucleicAtomIDs, specialAtomID);
    }

    Point3f getAtomPoint(byte specialAtomID) {
        return this.getSpecialAtomPoint(interestingNucleicAtomIDs, specialAtomID);
    }

    Atom getTerminatorAtom() {
        return this.getAtomFromOffsetIndex(this.offsets[23] != -1 ? 23 : 24);
    }

    Atom getO3PrimeAtom() {
        return this.getAtomFromOffsetIndex(24);
    }

    Atom getPhosphorusAtom() {
        return this.getAtomFromOffsetIndex(25);
    }

    void getBaseRing6Points(Point3f[] ring6Points) {
        int i = 6;
        while (--i >= 0) {
            ring6Points[i] = this.getAtomPointFromOffsetIndex(i + 3);
        }
    }

    boolean maybeGetBaseRing5Points(Point3f[] ring5Points) {
        if (this.isPurine) {
            int i = 5;
            while (--i >= 0) {
                ring5Points[i] = this.getAtomPointFromOffsetIndex(ring5OffsetIndexes[i]);
            }
        }
        return this.isPurine;
    }

    boolean isConnectedAfter(Monomer possiblyPreviousMonomer) {
        if (possiblyPreviousMonomer == null) {
            return true;
        }
        Atom myPhosphorusAtom = this.getPhosphorusAtom();
        if (myPhosphorusAtom == null) {
            return false;
        }
        if (!(possiblyPreviousMonomer instanceof NucleicMonomer)) {
            return false;
        }
        NucleicMonomer other = (NucleicMonomer)possiblyPreviousMonomer;
        return other.getO3PrimeAtom().isBonded(myPhosphorusAtom);
    }

    void findNearestAtomIndex(int x, int y, Closest closest, short madBegin, short madEnd) {
    }
}

