/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.openscience.jmol.viewer.datamodel.Monomer;
import org.openscience.jmol.viewer.datamodel.Mps;
import org.openscience.jmol.viewer.datamodel.MpsRenderer;
import org.openscience.jmol.viewer.datamodel.NucleicPolymer;
import org.openscience.jmol.viewer.datamodel.Trace;

class TraceRenderer
extends MpsRenderer {
    boolean isNucleicPolymer;
    int monomerCount;
    Monomer[] monomers;
    Point3i[] leadMidpointScreens;
    Point3f[] leadMidpoints;

    TraceRenderer() {
    }

    void renderMpspolymer(Mps.Mpspolymer mpspolymer) {
        Trace.Tchain tchain = (Trace.Tchain)mpspolymer;
        this.isNucleicPolymer = tchain.polymer instanceof NucleicPolymer;
        this.monomerCount = tchain.monomerCount;
        if (this.monomerCount == 0) {
            return;
        }
        this.monomers = tchain.monomers;
        this.leadMidpoints = tchain.leadMidpoints;
        this.leadMidpointScreens = this.calcScreenLeadMidpoints(this.monomerCount, this.leadMidpoints);
        this.render1Chain(tchain.mads, tchain.colixes);
        this.viewer.freeTempScreens(this.leadMidpointScreens);
    }

    void render1Chain(short[] mads, short[] colixes) {
        int i = this.monomerCount;
        while (--i >= 0) {
            if (mads[i] == 0) continue;
            short colix = colixes[i];
            if (colix == 0) {
                colix = this.monomers[i].getLeadAtom().colixAtom;
            }
            this.renderRopeSegment(colix, mads, i, this.monomerCount, this.monomers, this.leadMidpointScreens, null);
        }
    }
}

