/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginPathFinder;

public class ExternalModelManager {
    private List fModels;
    private List fFragmentModels;
    private Vector fListeners = new Vector();
    private PDEState fState = null;
    private boolean fInitialized = false;

    public ExternalModelManager() {
        this.fModels = Collections.synchronizedList(new ArrayList());
        this.fFragmentModels = Collections.synchronizedList(new ArrayList());
    }

    public static String computeDefaultPlatformPath() {
        URL installURL = Platform.getInstallLocation().getURL();
        IPath ppath = new Path(installURL.getFile()).removeTrailingSeparator();
        return ExternalModelManager.getCorrectPath(ppath.toOSString());
    }

    public static boolean isTargetEqualToHost(String platformPath) {
        return ExternalModelManager.arePathsEqual((IPath)new Path(platformPath), (IPath)new Path(ExternalModelManager.computeDefaultPlatformPath()));
    }

    /*
     * Unable to fully structure code
     */
    private static String getCorrectPath(String path) {
        buf = new StringBuffer();
        i = 0;
        while (i < path.length()) {
            block3: {
                c = path.charAt(i);
                if (Platform.getOS().equals("win32") && i == 0 && c == '/') break block3;
                if (c != '%' || i + 2 >= path.length()) ** GOTO lbl-1000
                c1 = path.charAt(i + 1);
                c2 = path.charAt(i + 2);
                if (c1 == '2' && c2 == '0') {
                    i += 2;
                    buf.append(" ");
                } else lbl-1000:
                // 2 sources

                {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static IPath getEclipseHome() {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        return new Path(preferences.getString("platform_path"));
    }

    public static boolean arePathsEqual(IPath path1, IPath path2) {
        String device = path1.getDevice();
        if (device != null) {
            path1 = path1.setDevice(device.toUpperCase());
        }
        if ((device = path2.getDevice()) != null) {
            path2 = path2.setDevice(device.toUpperCase());
        }
        return path1.equals((Object)path2);
    }

    public void addModelProviderListener(IModelProviderListener listener) {
        this.fListeners.add(listener);
    }

    private Vector createSavedList(String saved) {
        Vector<String> result = new Vector<String>();
        StringTokenizer stok = new StringTokenizer(saved);
        while (stok.hasMoreTokens()) {
            result.add(stok.nextToken());
        }
        return result;
    }

    private void enableAll() {
        int i = 0;
        while (i < this.fModels.size()) {
            ((IPluginModel)this.fModels.get(i)).setEnabled(true);
            ++i;
        }
        i = 0;
        while (i < this.fFragmentModels.size()) {
            ((IFragmentModel)this.fFragmentModels.get(i)).setEnabled(true);
            ++i;
        }
    }

    public void fireModelProviderEvent(IModelProviderEvent e) {
        Iterator iter = this.fListeners.iterator();
        while (iter.hasNext()) {
            IModelProviderListener listener = (IModelProviderListener)iter.next();
            listener.modelsChanged(e);
        }
    }

    public IPluginModelBase[] getAllModels() {
        this.loadModels((IProgressMonitor)new NullProgressMonitor());
        IPluginModelBase[] allModels = new IPluginModelBase[this.fModels.size() + this.fFragmentModels.size()];
        System.arraycopy(this.fModels.toArray(), 0, allModels, 0, this.fModels.size());
        System.arraycopy(this.fFragmentModels.toArray(), 0, allModels, this.fModels.size(), this.fFragmentModels.size());
        return allModels;
    }

    private void initializeAllModels() {
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        String saved = pref.getString("checkedPlugins");
        if (saved.equals("[savedAll]")) {
            this.enableAll();
        } else if (!saved.equals("[savedNone]")) {
            Vector list = this.createSavedList(saved);
            int i = 0;
            while (i < this.fModels.size()) {
                IPluginModel model;
                model.setEnabled(!list.contains((model = (IPluginModel)this.fModels.get(i)).getPlugin().getId()));
                ++i;
            }
            i = 0;
            while (i < this.fFragmentModels.size()) {
                IFragmentModel fmodel;
                fmodel.setEnabled(!list.contains((fmodel = (IFragmentModel)this.fFragmentModels.get(i)).getFragment().getId()));
                ++i;
            }
        }
    }

    private synchronized void loadModels(IProgressMonitor monitor) {
        if (this.fInitialized) {
            return;
        }
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        URL[] pluginPaths = PluginPathFinder.getPluginPaths(pref.getString("platform_path"));
        this.fState = new PDEState(pluginPaths, true, monitor);
        IPluginModelBase[] resolved = this.fState.getModels();
        int i = 0;
        while (i < resolved.length) {
            if (resolved[i] instanceof IPluginModel) {
                this.fModels.add(resolved[i]);
            } else {
                this.fFragmentModels.add(resolved[i]);
            }
            ++i;
        }
        this.initializeAllModels();
        this.fInitialized = true;
    }

    public void removeModelProviderListener(IModelProviderListener listener) {
        this.fListeners.remove(listener);
    }

    public void reset(PDEState state, IPluginModelBase[] newModels) {
        this.fState = state;
        PDECore.getDefault().getModelManager().addWorkspaceBundlesToState();
        this.fModels.clear();
        this.fFragmentModels.clear();
        int i = 0;
        while (i < newModels.length) {
            if (newModels[i] instanceof IPluginModel) {
                this.fModels.add(newModels[i]);
            } else {
                this.fFragmentModels.add(newModels[i]);
            }
            ++i;
        }
    }

    public void shutdown() {
        int disabled = 0;
        StringBuffer saved = new StringBuffer();
        int i = 0;
        while (i < this.fModels.size()) {
            IPluginModel model = (IPluginModel)this.fModels.get(i);
            if (!model.isEnabled()) {
                ++disabled;
                if (saved.length() > 0) {
                    saved.append(" ");
                }
                saved.append(model.getPlugin().getId());
            }
            ++i;
        }
        i = 0;
        while (i < this.fFragmentModels.size()) {
            IFragmentModel fmodel = (IFragmentModel)this.fFragmentModels.get(i);
            if (!fmodel.isEnabled()) {
                ++disabled;
                if (saved.length() > 0) {
                    saved.append(" ");
                }
                saved.append(fmodel.getFragment().getId());
            }
            ++i;
        }
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        if (disabled == 0) {
            pref.setValue("checkedPlugins", "[savedAll]");
        } else if (disabled == this.fModels.size() + this.fFragmentModels.size()) {
            pref.setValue("checkedPlugins", "[savedNone]");
        } else {
            pref.setValue("checkedPlugins", saved.toString());
        }
        PDECore.getDefault().savePluginPreferences();
    }

    public PDEState getState() {
        this.loadModels((IProgressMonitor)new NullProgressMonitor());
        return this.fState;
    }
}

