/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEStateHelper;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModelBase;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PDEState {
    private static boolean DEBUG = false;
    private static StateObjectFactory stateObjectFactory;
    private static String DIR;
    protected State fState;
    private long fId;
    private URL[] fURLs;
    private boolean fResolve;
    private String fTargetMode = null;
    private PluginConverter fConverter = null;
    private IProgressMonitor fMonitor;
    private IPluginModelBase[] fModels;
    private HashMap fPluginInfos;
    private HashMap fExtensions;
    static /* synthetic */ Class class$0;

    static {
        DEBUG = PDECore.getDefault().isDebugging() && "true".equals(Platform.getDebugOption((String)"org.eclipse.pde.core/cache"));
        DIR = PDECore.getDefault().getStateLocation().append(".cache").toOSString();
        stateObjectFactory = Platform.getPlatformAdmin().getFactory();
    }

    public PDEState() {
        this.fMonitor = new NullProgressMonitor();
        this.fPluginInfos = new HashMap();
        this.fState = stateObjectFactory.createState();
        this.fState.setResolver(Platform.getPlatformAdmin().getResolver());
    }

    public PDEState(URL[] urls, boolean resolve, IProgressMonitor monitor) {
        this.fURLs = urls;
        this.fMonitor = monitor;
        this.fResolve = resolve;
        this.fPluginInfos = new HashMap();
        long start = System.currentTimeMillis();
        if (this.fResolve) {
            long timestamp = this.computeTimestamp(this.fURLs);
            if (!this.readStateCache(timestamp) || !this.reachPluginInfoCache(timestamp)) {
                this.createState();
                this.saveState(timestamp);
                this.savePluginInfo(timestamp);
            } else {
                this.fId = this.fState.getBundles().length;
            }
            if (!this.readExtensionsCache(timestamp)) {
                this.saveExtensions(timestamp);
            }
        } else {
            this.createState();
        }
        this.fState.setResolver(Platform.getPlatformAdmin().getResolver());
        this.fState.resolve();
        if (this.fResolve) {
            this.logResolutionErrors();
        }
        this.createModels();
        long end = System.currentTimeMillis();
        if (DEBUG) {
            System.out.println("Total time elapsed to initialize models: " + (end - start) + " ms");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean reachPluginInfoCache(long timestamp) {
        long start;
        block11: {
            File file = new File(DIR, String.valueOf(Long.toString(timestamp)) + ".pluginInfo");
            if (!file.exists()) return false;
            if (!file.isFile()) return false;
            start = System.currentTimeMillis();
            try {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    Document doc = factory.newDocumentBuilder().parse(file);
                    Element root = doc.getDocumentElement();
                    if (root != null) {
                        NodeList bundles = root.getElementsByTagName("bundle");
                        int i = 0;
                        while (true) {
                            if (i >= bundles.getLength()) {
                                break;
                            }
                            this.createPluginInfo((Element)bundles.item(i));
                            ++i;
                        }
                    }
                    Object var11_12 = null;
                }
                catch (SAXException e) {
                    PDECore.log(e);
                    break block11;
                }
                catch (IOException e) {
                    PDECore.log(e);
                    break block11;
                }
                catch (ParserConfigurationException e) {
                    PDECore.log(e);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                long end = System.currentTimeMillis();
                if (!DEBUG) throw throwable;
                System.out.println("########Time to read plugin info from cache: " + (end - start) + "ms");
                throw throwable;
            }
            long end = System.currentTimeMillis();
            if (!DEBUG) return true;
            System.out.println("########Time to read plugin info from cache: " + (end - start) + "ms");
            return true;
        }
        Object var11_14 = null;
        long end = System.currentTimeMillis();
        if (!DEBUG) return false;
        System.out.println("########Time to read plugin info from cache: " + (end - start) + "ms");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readExtensionsCache(long timestamp) {
        long start;
        block11: {
            this.fExtensions = new HashMap();
            File file = new File(DIR, String.valueOf(Long.toString(timestamp)) + ".extensions");
            if (!file.exists()) return false;
            if (!file.isFile()) return false;
            start = System.currentTimeMillis();
            try {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    Document doc = factory.newDocumentBuilder().parse(file);
                    Element root = doc.getDocumentElement();
                    if (root != null) {
                        NodeList bundles = root.getElementsByTagName("bundle");
                        int i = 0;
                        while (true) {
                            if (i >= bundles.getLength()) {
                                break;
                            }
                            Element bundle = (Element)bundles.item(i);
                            String id = bundle.getAttribute("bundleID");
                            this.fExtensions.put(id, bundle.getChildNodes());
                            ++i;
                        }
                    }
                    Object var13_14 = null;
                }
                catch (SAXException e) {
                    PDECore.log(e);
                    break block11;
                }
                catch (IOException e) {
                    PDECore.log(e);
                    break block11;
                }
                catch (ParserConfigurationException e) {
                    PDECore.log(e);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                long end = System.currentTimeMillis();
                if (!DEBUG) throw throwable;
                System.out.println("########Time to read extensions from cache: " + (end - start) + "ms");
                throw throwable;
            }
            long end = System.currentTimeMillis();
            if (!DEBUG) return true;
            System.out.println("########Time to read extensions from cache: " + (end - start) + "ms");
            return true;
        }
        Object var13_16 = null;
        long end = System.currentTimeMillis();
        if (!DEBUG) return false;
        System.out.println("########Time to read extensions from cache: " + (end - start) + "ms");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readStateCache(long timestamp) {
        FileInputStream stream;
        long start;
        block15: {
            File file = new File(DIR, String.valueOf(Long.toString(timestamp)) + ".state");
            if (!file.exists()) return false;
            if (!file.isFile()) return false;
            start = System.currentTimeMillis();
            stream = null;
            try {
                try {
                    stream = new FileInputStream(file);
                    this.fState = stateObjectFactory.readState((InputStream)stream);
                    Object var8_5 = null;
                }
                catch (IllegalStateException e) {
                    PDECore.log(e);
                    break block15;
                }
                catch (FileNotFoundException e) {
                    PDECore.log(e);
                    break block15;
                }
                catch (IOException e) {
                    PDECore.log(e);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
                catch (IOException iOException) {}
                long end = System.currentTimeMillis();
                if (!DEBUG) throw throwable;
                System.out.println("########Time to read state from cache: " + (end - start) + "ms");
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (stream != null) {
                ((InputStream)stream).close();
            }
            long end = System.currentTimeMillis();
            if (!DEBUG) return true;
            System.out.println("########Time to read state from cache: " + (end - start) + "ms");
            return true;
        }
        Object var8_7 = null;
        try {}
        catch (IOException iOException) {}
        if (stream != null) {
            ((InputStream)stream).close();
        }
        long end = System.currentTimeMillis();
        if (!DEBUG) return false;
        System.out.println("########Time to read state from cache: " + (end - start) + "ms");
        return false;
    }

    private void createState() {
        long start = System.currentTimeMillis();
        this.fState = stateObjectFactory.createState();
        this.fPluginInfos.clear();
        this.populate();
        long end = System.currentTimeMillis();
        if (DEBUG) {
            System.out.println("########Time to create state from scratch: " + (end - start) + "ms");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveState(long timestamp) {
        long start = System.currentTimeMillis();
        File file = this.createFile(timestamp, "state");
        FileOutputStream stream = null;
        try {
            try {
                stream = new FileOutputStream(file);
                stateObjectFactory.writeState(this.fState, (OutputStream)stream);
            }
            catch (FileNotFoundException e) {
                PDECore.log(e);
            }
            catch (IOException e) {
                PDECore.log(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stream == null) throw throwable;
                ((OutputStream)stream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (stream != null) {
            ((OutputStream)stream).close();
        }
        long end = System.currentTimeMillis();
        if (!DEBUG) return;
        System.out.println("########Time to save new state: " + (end - start) + "ms");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void savePluginInfo(long timestamp) {
        long start = System.currentTimeMillis();
        File file = this.createFile(timestamp, "pluginInfo");
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(file);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document doc = factory.newDocumentBuilder().newDocument();
                Element root = doc.createElement("map");
                Iterator iter = this.fPluginInfos.keySet().iterator();
                while (true) {
                    if (!iter.hasNext()) {
                        doc.appendChild(root);
                        XMLPrintHandler.printNode(writer, doc, "UTF-8");
                    }
                    String key = iter.next().toString();
                    Element element = doc.createElement("bundle");
                    element.setAttribute("bundleID", key);
                    PluginInfo info = (PluginInfo)this.fPluginInfos.get(key);
                    if (info.className != null) {
                        element.setAttribute("class", info.className);
                    }
                    if (info.providerName != null) {
                        element.setAttribute("provider", info.providerName);
                    }
                    if (info.name != null) {
                        element.setAttribute("name", info.name);
                    }
                    if (info.libraries != null) {
                        int i = 0;
                        while (i < info.libraries.length) {
                            Element lib = doc.createElement("library");
                            lib.setAttribute("name", info.libraries[i]);
                            element.appendChild(lib);
                            ++i;
                        }
                    }
                    root.appendChild(element);
                }
            }
            catch (Exception e) {
                PDECore.log(e);
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            try {
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var16_18 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (writer != null) {
            writer.close();
        }
        long end = System.currentTimeMillis();
        if (!DEBUG) return;
        System.out.println("########Time to save new aux plugin info: " + (end - start) + "ms");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveExtensions(long timestamp) {
        this.fExtensions = new HashMap();
        long start = System.currentTimeMillis();
        File file = this.createFile(timestamp, "extensions");
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(file);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document doc = factory.newDocumentBuilder().newDocument();
                Element root = doc.createElement("extensions");
                BundleDescription[] bundles = this.fState.getBundles();
                int i = 0;
                while (true) {
                    if (i >= bundles.length) {
                        doc.appendChild(root);
                        XMLPrintHandler.printNode(writer, doc, "UTF-8");
                    }
                    BundleDescription desc = bundles[i];
                    Element element = doc.createElement("bundle");
                    element.setAttribute("bundleID", Long.toString(desc.getBundleId()));
                    PDEStateHelper.parseExtensions(desc, element);
                    if (element.hasChildNodes()) {
                        root.appendChild(element);
                        this.fExtensions.put(Long.toString(desc.getBundleId()), element);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                PDECore.log(e);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var14_16 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (writer != null) {
            writer.close();
        }
        long end = System.currentTimeMillis();
        if (!DEBUG) return;
        System.out.println("########Time to parse and save extensions: " + (end - start) + "ms");
    }

    private File createFile(long timestamp, String extension) {
        File dir = new File(DIR);
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        } else {
            File[] files = dir.listFiles();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    File file = files[i];
                    if (file.isFile() && file.getName().endsWith("." + extension)) {
                        file.delete();
                    }
                    ++i;
                }
            }
        }
        return new File(dir, String.valueOf(Long.toString(timestamp)) + "." + extension);
    }

    private long getNextId() {
        return ++this.fId;
    }

    private StateHelper acquireStateHelper() {
        return PDECore.getDefault().acquirePlatform().getStateHelper();
    }

    private BundleDescription findActiveBundle(String symbolicName) {
        BundleDescription[] bundles = this.fState.getBundles(symbolicName);
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].isResolved()) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    private void logResolutionErrors() {
        MultiStatus errors = new MultiStatus(PDECore.getPluginId(), 1, PDECore.getResourceString("ExternalModelManager.scanningProblems"), null);
        StateHelper helper = this.acquireStateHelper();
        BundleDescription[] all = this.fState.getBundles();
        int i = 0;
        while (i < all.length) {
            if (!all[i].isResolved()) {
                String message;
                VersionConstraint[] unsatisfiedConstraints = helper.getUnsatisfiedConstraints(all[i]);
                if (unsatisfiedConstraints.length == 0) {
                    BundleDescription activeBundle = this.findActiveBundle(all[i].getSymbolicName());
                    if (activeBundle == null) {
                        message = PDECore.getFormattedMessage("ECLIPSE_IGNORE", all[i].getLocation());
                        errors.add((IStatus)new Status(4, all[i].getSymbolicName(), 2, message, null));
                    } else {
                        message = PDECore.getFormattedMessage("ECLIPSE_OTHER_VERSION", new String[]{all[i].getLocation(), activeBundle.getLocation()});
                        errors.add((IStatus)new Status(1, all[i].getSymbolicName(), 1, message, null));
                    }
                } else {
                    int j = 0;
                    while (j < unsatisfiedConstraints.length) {
                        message = this.getResolutionFailureMessage(unsatisfiedConstraints[j]);
                        errors.add((IStatus)new Status(2, all[i].getSymbolicName(), 2, message, null));
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (errors.getChildren().length > 0) {
            PDECore.log((IStatus)errors);
        }
    }

    private String getResolutionFailureMessage(VersionConstraint unsatisfied) {
        if (unsatisfied.isResolved()) {
            throw new IllegalArgumentException();
        }
        if (unsatisfied instanceof PackageSpecification) {
            return PDECore.getFormattedMessage("ECLIPSE_MISSING_IMPORTED_PACKAGE", this.toString(unsatisfied));
        }
        if (unsatisfied instanceof BundleSpecification) {
            if (((BundleSpecification)unsatisfied).isOptional()) {
                return PDECore.getFormattedMessage("ECLIPSE_MISSING_OPTIONAL_REQUIRED_BUNDLE", this.toString(unsatisfied));
            }
            return PDECore.getFormattedMessage("ECLIPSE_MISSING_REQUIRED_BUNDLE", this.toString(unsatisfied));
        }
        return PDECore.getFormattedMessage("ECLIPSE_MISSING_HOST", this.toString(unsatisfied));
    }

    private String toString(VersionConstraint constraint) {
        VersionRange versionRange = constraint.getVersionRange();
        if (versionRange == null || versionRange.getMinimum() != null) {
            return constraint.getName();
        }
        return String.valueOf(constraint.getName()) + '_' + versionRange;
    }

    private void populate() {
        if (this.fURLs == null || this.fURLs.length == 0) {
            return;
        }
        this.setTargetMode();
        this.fMonitor.beginTask("", this.fURLs.length);
        int i = 0;
        while (i < this.fURLs.length) {
            this.addBundle(new File(this.fURLs[i].getFile()), true, true);
            this.fMonitor.worked(1);
            ++i;
        }
    }

    private long computeTimestamp(URL[] urls) {
        long timestamp = 0L;
        int i = 0;
        while (i < urls.length) {
            File file = new File(urls[i].getFile());
            if (file.exists()) {
                if (file.isFile()) {
                    timestamp ^= file.lastModified();
                } else {
                    File manifest = new File(file, "META-INF/MANIFEST.MF");
                    if (manifest.exists()) {
                        timestamp ^= manifest.lastModified();
                    }
                    if ((manifest = new File(file, "plugin.xml")).exists()) {
                        timestamp ^= manifest.lastModified();
                    }
                    if ((manifest = new File(file, "fragment.xml")).exists()) {
                        timestamp ^= manifest.lastModified();
                    }
                }
            }
            ++i;
        }
        return timestamp;
    }

    public void addBundleDescription(BundleDescription toAdd) {
        this.fState.addBundle(toAdd);
    }

    private PluginConverter acquirePluginConverter() throws Exception {
        if (this.fConverter == null) {
            BundleContext bundleContext = PDECore.getDefault().getBundleContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.service.pluginconversion.PluginConverter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ServiceTracker tracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            tracker.open();
            this.fConverter = (PluginConverter)tracker.getService();
            tracker.close();
        }
        return this.fConverter;
    }

    public BundleDescription addBundle(Dictionary manifest, File bundleLocation, boolean keepLibraries) {
        try {
            BundleDescription descriptor = stateObjectFactory.createBundleDescription(manifest, bundleLocation.getAbsolutePath(), this.getNextId());
            if (keepLibraries) {
                this.createPluginInfo(descriptor, manifest);
            }
            this.fState.addBundle(descriptor);
            return descriptor;
        }
        catch (BundleException bundleException) {
            return null;
        }
    }

    private void createPluginInfo(BundleDescription desc, Dictionary manifest) {
        PluginInfo info = new PluginInfo();
        info.name = (String)manifest.get("Bundle-Name");
        info.providerName = (String)manifest.get("Bundle-Vendor");
        String className = (String)manifest.get("Plugin-Class");
        info.className = className != null ? className : (String)manifest.get("Bundle-Activator");
        info.libraries = PDEStateHelper.getClasspath(manifest);
        this.fPluginInfos.put(Long.toString(desc.getBundleId()), info);
    }

    private void createPluginInfo(Element element) {
        PluginInfo info = new PluginInfo();
        info.name = element.getAttribute("name");
        info.providerName = element.getAttribute("provider");
        info.className = element.getAttribute("class");
        NodeList libs = element.getElementsByTagName("library");
        info.libraries = new String[libs.getLength()];
        int i = 0;
        while (i < libs.getLength()) {
            Element lib = (Element)libs.item(i);
            info.libraries[i] = lib.getAttribute("name");
            ++i;
        }
        this.fPluginInfos.put(element.getAttribute("bundleID"), info);
    }

    public BundleDescription addBundle(File bundleLocation) {
        return this.addBundle(bundleLocation, false, false);
    }

    public BundleDescription addBundle(File bundleLocation, boolean keepLibraries, boolean logException) {
        Dictionary manifest = this.loadManifest(bundleLocation);
        if (manifest == null || manifest.get("Bundle-SymbolicName") == null) {
            try {
                if (!new File(bundleLocation, "plugin.xml").exists() && !new File(bundleLocation, "fragment.xml").exists()) {
                    return null;
                }
                PluginConverter converter = this.acquirePluginConverter();
                manifest = converter.convertManifest(bundleLocation, false, this.getTargetMode(), false);
                if (manifest == null || manifest.get("Bundle-SymbolicName") == null) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                if (logException) {
                    PDECore.log((IStatus)new Status(4, "org.eclipse.pde.core", 4, "Error parsing plugin manifest file at " + bundleLocation.toString(), null));
                }
                return null;
            }
        }
        return this.addBundle(manifest, bundleLocation, keepLibraries);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Dictionary loadManifest(File bundleLocation) {
        Object var4_4;
        Properties properties;
        InputStream manifestStream = null;
        try {
            URL manifestLocation = null;
            String extension = new Path(bundleLocation.getName()).getFileExtension();
            if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                manifestLocation = new URL("jar:file:" + bundleLocation + "!/" + "META-INF/MANIFEST.MF");
                manifestStream = manifestLocation.openStream();
            } else {
                manifestStream = new FileInputStream(new File(bundleLocation, "META-INF/MANIFEST.MF"));
            }
        }
        catch (IOException iOException) {}
        if (manifestStream == null) {
            return null;
        }
        try {
            try {
                Manifest m = new Manifest(manifestStream);
                properties = this.manifestToProperties(m.getMainAttributes());
                var4_4 = null;
            }
            catch (IOException iOException) {
                PDECore.log((IStatus)new Status(4, "org.eclipse.pde.core", 4, String.valueOf(PDECore.getResourceString("PDEState.invalidFormat")) + bundleLocation.toString(), null));
                Dictionary dictionary = null;
                var4_4 = null;
                try {
                    manifestStream.close();
                    return dictionary;
                }
                catch (IOException iOException2) {}
                return dictionary;
            }
        }
        catch (Throwable throwable) {
            var4_4 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            manifestStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        manifestStream.close();
        return properties;
    }

    private Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }

    public StateDelta resolveState() {
        return this.fState.resolve(false);
    }

    public void resolveState(boolean incremental) {
        this.fState.resolve(incremental);
    }

    public void removeBundleDescription(BundleDescription description) {
        this.fState.removeBundle(description);
    }

    public State getState() {
        return this.fState;
    }

    public void setTargetMode() {
        this.fTargetMode = "2.1";
        int i = 0;
        while (i < this.fURLs.length) {
            if (this.fURLs[i].getFile().indexOf("org.eclipse.osgi") != -1) {
                this.fTargetMode = null;
                break;
            }
            ++i;
        }
    }

    public String getTargetMode() {
        return this.fTargetMode;
    }

    private void createModels() {
        long start = System.currentTimeMillis();
        BundleDescription[] bundleDescriptions = this.fResolve ? this.fState.getResolvedBundles() : this.fState.getBundles();
        this.fModels = new IPluginModelBase[bundleDescriptions.length];
        int i = 0;
        while (i < bundleDescriptions.length) {
            BundleDescription desc = bundleDescriptions[i];
            this.fMonitor.subTask(bundleDescriptions[i].getSymbolicName());
            ExternalPluginModelBase model = null;
            model = desc.getHost() == null ? new ExternalPluginModel() : new ExternalFragmentModel();
            model.load(desc, this, !this.fResolve);
            this.fModels[i] = model;
            ++i;
        }
        long end = System.currentTimeMillis();
        if (DEBUG) {
            System.out.println("########Time to populate models: " + (end - start) + " ms");
        }
        if (this.fExtensions != null) {
            this.fExtensions.clear();
        }
        this.fPluginInfos.clear();
        this.fMonitor.done();
    }

    public IPluginModelBase[] getModels() {
        return this.fModels;
    }

    public String getClassName(long bundleID) {
        PluginInfo info = (PluginInfo)this.fPluginInfos.get(Long.toString(bundleID));
        return info == null ? null : info.className;
    }

    public String getPluginName(long bundleID) {
        PluginInfo info = (PluginInfo)this.fPluginInfos.get(Long.toString(bundleID));
        return info == null ? null : info.name;
    }

    public String getProviderName(long bundleID) {
        PluginInfo info = (PluginInfo)this.fPluginInfos.get(Long.toString(bundleID));
        return info == null ? null : info.providerName;
    }

    public String[] getLibraryNames(long bundleID) {
        PluginInfo info = (PluginInfo)this.fPluginInfos.get(Long.toString(bundleID));
        return info == null ? new String[]{} : info.libraries;
    }

    public NodeList getExtensions(long bundleID) {
        return this.getChildren(bundleID, "extension");
    }

    public NodeList getExtensionPoints(long bundleID) {
        return this.getChildren(bundleID, "extension-point");
    }

    private NodeList getChildren(long bundleID, String tagName) {
        Element bundle;
        if (this.fExtensions != null && (bundle = (Element)this.fExtensions.get(Long.toString(bundleID))) != null) {
            return bundle.getElementsByTagName(tagName);
        }
        return null;
    }

    class PluginInfo {
        String name;
        String providerName;
        String className;
        String[] libraries;

        PluginInfo() {
        }
    }
}

