/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bundle;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleFragment;
import org.eclipse.pde.internal.core.plugin.PluginBase;

public class BundleFragment
extends BundlePluginBase
implements IBundleFragment {
    private static final long serialVersionUID = 1L;

    public String getPluginId() {
        return this.parseSingleValuedHeader("Fragment-Host");
    }

    public String getPluginVersion() {
        String version = this.getAttribute("Fragment-Host", "bundle-version");
        VersionRange versionRange = new VersionRange(version);
        if (versionRange != null) {
            return versionRange.getMinimum() != null ? versionRange.getMinimum().toString() : version;
        }
        return version;
    }

    public int getRule() {
        String version = this.getAttribute("Fragment-Host", "bundle-version");
        VersionRange versionRange = new VersionRange(version);
        return PluginBase.getMatchRule(versionRange);
    }

    public void setPluginId(String id) throws CoreException {
        IBundle bundle = this.getBundle();
        if (bundle != null) {
            String oldValue = this.getPluginId();
            bundle.setHeader("Fragment-Host", this.writeFragmentHost(id, this.getPluginVersion()));
            this.model.fireModelObjectChanged(this, "plugin-id", oldValue, id);
        }
    }

    public void setPluginVersion(String version) throws CoreException {
        IBundle bundle = this.getBundle();
        if (bundle != null) {
            String oldValue = this.getPluginVersion();
            bundle.setHeader("Fragment-Host", this.writeFragmentHost(this.getPluginId(), version));
            this.model.fireModelObjectChanged(this, "plugin-version", oldValue, version);
        }
    }

    public void setRule(int rule) throws CoreException {
    }

    private String writeFragmentHost(String id, String version) {
        StringBuffer buffer = new StringBuffer();
        if (id != null) {
            buffer.append(id);
        }
        if (version != null && version.trim().length() > 0) {
            buffer.append(";bundle-version=\"" + version.trim() + "\"");
        }
        return buffer.toString();
    }
}

