/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.feature;

import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.feature.FeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeatureInstallHandler;
import org.w3c.dom.Node;

public class FeatureInstallHandler
extends FeatureObject
implements IFeatureInstallHandler {
    private static final long serialVersionUID = 1L;
    private URL url;
    private String library;
    private String handlerName;

    public URL getURL() {
        return this.url;
    }

    public String getLibrary() {
        return this.library;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public void setURL(URL url) throws CoreException {
        this.ensureModelEditable();
        URL oldValue = this.url;
        this.url = url;
        this.firePropertyChanged("url", oldValue, url);
    }

    public void setLibrary(String library) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.library;
        this.library = library;
        this.firePropertyChanged("library", oldValue, library);
    }

    public void setHandlerName(String handlerName) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.handlerName;
        this.handlerName = handlerName;
        this.firePropertyChanged("handlerName", oldValue, handlerName);
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("url")) {
            this.setURL((URL)newValue);
        } else if (name.equals("library")) {
            this.setLibrary((String)newValue);
        } else if (name.equals("handlerName")) {
            this.setHandlerName((String)newValue);
        } else {
            super.restoreProperty(name, oldValue, newValue);
        }
    }

    protected void parse(Node node, Hashtable lineTable) {
        this.bindSourceLocation(node, lineTable);
        String urlName = this.getNodeAttribute(node, "url");
        if (urlName != null) {
            try {
                this.url = new URL(urlName);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.library = this.getNodeAttribute(node, "library");
        this.handlerName = this.getNodeAttribute(node, "handler");
    }

    public void write(String indent, PrintWriter writer) {
        writer.print(String.valueOf(indent) + "<install-handler");
        if (this.url != null) {
            writer.print(" url=\"" + this.url.toString() + "\"");
        }
        if (this.library != null) {
            writer.print(" library=\"" + this.library + "\"");
        }
        if (this.handlerName != null) {
            writer.print(" handler=\"" + this.handlerName + "\"");
        }
        writer.println("/>");
    }
}

