/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.model;

public class MemoryByte {
    public static final byte READONLY = 1;
    public static final byte VALID = 2;
    public static final byte CHANGED = 4;
    public static final byte KNOWN = 8;
    protected byte value;
    protected byte flags;

    public MemoryByte() {
        this(0, 2);
    }

    public MemoryByte(byte byteValue) {
        this(byteValue, 2);
    }

    public MemoryByte(byte byteValue, byte byteFlags) {
        this.value = byteValue;
        this.flags = byteFlags;
    }

    public byte getFlags() {
        return this.flags;
    }

    public void setFlags(byte flags) {
        this.flags = flags;
    }

    public byte getValue() {
        return this.value;
    }

    public void setValue(byte value) {
        this.value = value;
    }

    public void setValid(boolean valid) {
        this.flags = (byte)(this.flags | 2);
        if (!valid) {
            this.flags = (byte)(this.flags ^ 2);
        }
    }

    public boolean isValid() {
        return (this.flags & 2) == 2;
    }

    public void setReadonly(boolean readonly) {
        this.flags = (byte)(this.flags | 1);
        if (!readonly) {
            this.flags = (byte)(this.flags ^ 1);
        }
    }

    public boolean isReadonly() {
        return (this.flags & 1) == 1;
    }

    public void setChanged(boolean changed) {
        this.flags = (byte)(this.flags | 4);
        if (!changed) {
            this.flags = (byte)(this.flags ^ 4);
        }
    }

    public boolean isChanged() {
        return (this.flags & 4) == 4;
    }

    public void setKnown(boolean known) {
        this.flags = (byte)(this.flags | 8);
        if (!known) {
            this.flags = (byte)(this.flags ^ 8);
        }
    }

    public boolean isKnown() {
        return (this.flags & 8) == 8;
    }
}

