/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.internal.core.ConfigurationActivity;
import org.eclipse.update.internal.core.FeaturePlugin;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.core.InstallHandlerProxy;
import org.eclipse.update.internal.core.PatchedFeature;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfigurationPolicyModel;

public class ConfigurationPolicy
extends ConfigurationPolicyModel {
    public ConfigurationPolicy() {
    }

    public ConfigurationPolicy(ConfigurationPolicy configPolicy) {
        this.setPolicy(configPolicy.getPolicy());
        this.setConfiguredFeatureReferences(configPolicy.getConfiguredFeatures());
        this.setUnconfiguredFeatureReferences(configPolicy.getUnconfiguredFeatures());
        this.setConfiguredSiteModel(configPolicy.getConfiguredSiteModel());
    }

    private boolean isUnconfigured(IFeatureReference featureReference) {
        if (featureReference == null) {
            return false;
        }
        IFeatureReference[] refs = this.getUnconfiguredFeatures();
        int i = 0;
        while (i < refs.length) {
            if (featureReference.equals(refs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isConfigured(IFeatureReference featureReference) {
        if (featureReference == null) {
            return false;
        }
        IFeatureReference[] refs = this.getConfiguredFeatures();
        int i = 0;
        while (i < refs.length) {
            if (featureReference.equals(refs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(IFeatureReference featureReference, boolean callInstallHandler, boolean createActivity) throws CoreException {
        block26: {
            block24: {
                if (this.isConfigured(featureReference)) {
                    return;
                }
                if (featureReference == null) {
                    UpdateCore.warn("The feature reference to configure is null");
                    return;
                }
                feature = null;
                try {
                    feature = featureReference.getFeature(null);
                }
                catch (CoreException e) {
                    if (UpdateManagerUtils.isOptional(featureReference)) break block24;
                    url = featureReference.getURL();
                    urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
                    UpdateCore.warn("Error retrieving feature:" + urlString, e);
                    return;
                }
            }
            if (feature == null) {
                url = featureReference.getURL();
                urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
                UpdateCore.warn("The feature to unconfigure is null: feature reference is:" + urlString);
            }
            handler = null;
            if (callInstallHandler && feature.getInstallHandlerEntry() != null) {
                handler = new InstallHandlerProxy(2, feature, feature.getInstallHandlerEntry(), null);
            }
            success = false;
            originalException = null;
            try {
                try {
                    if (handler != null) {
                        handler.configureInitiated();
                    }
                    activity = null;
                    if (createActivity) {
                        activity = new ConfigurationActivity(6);
                        activity.setLabel(feature.getVersionedIdentifier().toString());
                        activity.setDate(new Date());
                    }
                    this.addConfiguredFeatureReference((FeatureReferenceModel)featureReference);
                    if (activity != null) {
                        installConfig = (InstallConfiguration)SiteManager.getLocalSite().getCurrentConfiguration();
                        activity.setStatus(0);
                        installConfig.addActivity(activity);
                    }
                    if (handler != null) {
                        handler.completeConfigure();
                    }
                    success = true;
                }
                catch (Throwable t) {
                    originalException = t;
                }
            }
            catch (Throwable var11_15) {
                var10_16 = null;
                newException = null;
                try {
                    if (handler != null) {
                        handler.configureCompleted(success);
                    }
                }
                catch (Throwable t) {
                    newException = t;
                }
                if (originalException != null) {
                    throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), originalException);
                }
                if (newException != null) {
                    throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), newException);
                }
                throw var11_15;
            }
            {
                var10_17 = null;
                newException = null;
            }
            ** try [egrp 3[TRYBLOCK] [4 : 316->331)] { 
lbl66:
            // 1 sources

            if (handler != null) {
                handler.configureCompleted(success);
            }
            break block26;
lbl69:
            // 1 sources

            catch (Throwable t) {
                newException = t;
            }
        }
        if (originalException != null) {
            throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), originalException);
        }
        if (newException != null) {
            throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), newException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean unconfigure(IFeatureReference featureReference, boolean callInstallHandler, boolean createActivity) throws CoreException {
        block28: {
            block26: {
                if (this.isUnconfigured(featureReference)) {
                    UpdateCore.warn("Feature already unconfigured");
                    return true;
                }
                if (featureReference == null) {
                    UpdateCore.warn("The feature reference to unconfigure is null");
                    return false;
                }
                feature = null;
                try {
                    feature = featureReference.getFeature(null);
                }
                catch (CoreException e) {
                    if (UpdateManagerUtils.isOptional(featureReference)) break block26;
                    url = featureReference.getURL();
                    urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
                    UpdateCore.warn("Error retrieving feature:" + urlString, e);
                    return false;
                }
            }
            if (feature == null) {
                url = featureReference.getURL();
                urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
                UpdateCore.warn("The feature to unconfigure is null: feature reference is:" + urlString);
                return false;
            }
            handler = null;
            if (callInstallHandler && feature.getInstallHandlerEntry() != null) {
                handler = new InstallHandlerProxy(3, feature, feature.getInstallHandlerEntry(), null);
            }
            success = false;
            originalException = null;
            try {
                try {
                    activity = null;
                    if (createActivity) {
                        activity = new ConfigurationActivity(5);
                        activity.setLabel(feature.getVersionedIdentifier().toString());
                        activity.setDate(new Date());
                    }
                    installConfig = null;
                    if (activity != null) {
                        installConfig = (InstallConfiguration)SiteManager.getLocalSite().getCurrentConfiguration();
                    }
                    if (handler != null) {
                        handler.unconfigureInitiated();
                    }
                    this.addUnconfiguredFeatureReference((FeatureReferenceModel)featureReference);
                    if (handler != null) {
                        handler.completeUnconfigure();
                    }
                    if (activity != null) {
                        activity.setStatus(0);
                        installConfig.addActivity(activity);
                    }
                    success = true;
                }
                catch (Throwable t) {
                    originalException = t;
                }
            }
            catch (Throwable var11_16) {
                var10_17 = null;
                newException = null;
                try {
                    if (handler != null) {
                        handler.unconfigureCompleted(success);
                    }
                }
                catch (Throwable t) {
                    newException = t;
                }
                if (originalException != null) {
                    throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), originalException);
                }
                if (newException != null) {
                    throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), newException);
                }
                throw var11_16;
            }
            {
                var10_18 = null;
                newException = null;
            }
            ** try [egrp 3[TRYBLOCK] [4 : 333->348)] { 
lbl70:
            // 1 sources

            if (handler != null) {
                handler.unconfigureCompleted(success);
            }
            break block28;
lbl73:
            // 1 sources

            catch (Throwable t) {
                newException = t;
            }
        }
        if (originalException != null) {
            throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), originalException);
        }
        if (newException != null) {
            throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), newException);
        }
        if (!success) {
            url = featureReference.getURL();
            urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
            UpdateCore.warn("Unable to unconfigure:" + urlString);
        }
        return success;
    }

    public String[] getPluginPath(ISite site) throws CoreException {
        String[] pluginPaths;
        if (this.getPolicy() == 2) {
            return new String[0];
        }
        IFeatureReference[] unconfiguredFeatures = this.getUnconfiguredFeatures();
        IFeatureReference[] configuredFeatures = this.getConfiguredFeatures();
        if (!this.isEnabled()) {
            pluginPaths = this.getPolicy() == 0 ? new String[]{} : this.getAllKnownPluginStrings(site, configuredFeatures, unconfiguredFeatures);
        } else {
            PatchedFeature[] patchedFeatures = this.buildPatchedFeatures(configuredFeatures);
            pluginPaths = this.getPolicy() == 0 ? this.getConfiguredPluginStrings(site, patchedFeatures) : this.subtract(this.getAllKnownPluginStrings(site, configuredFeatures, unconfiguredFeatures), this.getConfiguredPluginStrings(site, patchedFeatures));
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("GetPluginPath for: " + (site == null ? "<No site>" : site.getURL().toString()));
            int i = 0;
            while (i < pluginPaths.length) {
                UpdateCore.debug("To write:" + pluginPaths[i]);
                ++i;
            }
        }
        return pluginPaths;
    }

    private PatchedFeature[] buildPatchedFeatures(IFeatureReference[] features) {
        HashMap<VersionedIdentifier, PatchedFeature> map = new HashMap<VersionedIdentifier, PatchedFeature>();
        int f = 0;
        while (f < features.length) {
            IFeatureReference featureRef = features[f];
            try {
                if (!featureRef.isPatch()) {
                    VersionedIdentifier vi = featureRef.getVersionedIdentifier();
                    map.put(vi, new PatchedFeature(features[f]));
                }
            }
            catch (CoreException e) {
                UpdateCore.warn(null, e);
            }
            ++f;
        }
        f = 0;
        while (f < features.length) {
            IFeatureReference patchCandidate = features[f];
            try {
                IFeature feature = patchCandidate.getFeature(null);
                IImport[] imports = feature.getImports();
                int i = 0;
                while (i < imports.length) {
                    VersionedIdentifier patchedIdentifier;
                    PatchedFeature pf;
                    IImport oneImport = imports[i];
                    if (oneImport.isPatch() && (pf = (PatchedFeature)map.get(patchedIdentifier = oneImport.getVersionedIdentifier())) != null) {
                        pf.addPatch(patchCandidate);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                UpdateCore.warn(null, e);
            }
            ++f;
        }
        Collection patchedFeatures = map.values();
        return patchedFeatures.toArray(new PatchedFeature[patchedFeatures.size()]);
    }

    public IFeatureReference[] getConfiguredFeatures() {
        FeatureReferenceModel[] result = this.getConfiguredFeaturesModel();
        if (result.length == 0) {
            return new IFeatureReference[0];
        }
        return (IFeatureReference[])result;
    }

    public IFeatureReference[] getUnconfiguredFeatures() {
        FeatureReferenceModel[] result = this.getUnconfiguredFeaturesModel();
        if (result.length == 0) {
            return new IFeatureReference[0];
        }
        return (IFeatureReference[])result;
    }

    public IConfiguredSite getConfiguredSite() {
        return (IConfiguredSite)((Object)this.getConfiguredSiteModel());
    }

    public void removeFeatureReference(IFeatureReference featureRef) {
        if (featureRef instanceof FeatureReferenceModel) {
            this.removeFeatureReference((FeatureReferenceModel)((Object)featureRef));
        }
    }

    private String[] getConfiguredPluginStrings(ISite site, PatchedFeature[] features) throws CoreException {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
            UpdateCore.warn("CONFIGURED PLUGINS");
        }
        HashSet<FeaturePlugin> featurePlugins = new HashSet<FeaturePlugin>();
        int i = 0;
        while (i < features.length) {
            FeaturePlugin[] plugins = features[i].getPlugins();
            featurePlugins.addAll(Arrays.asList(plugins));
            ++i;
        }
        Set pluginStrings = this.getPluginStrings(site, featurePlugins.toArray(new FeaturePlugin[featurePlugins.size()]));
        return pluginStrings.toArray(new String[pluginStrings.size()]);
    }

    private String[] getAllKnownPluginStrings(ISite site, IFeatureReference[] configured, IFeatureReference[] unconfigured) throws CoreException {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
            UpdateCore.warn("ALL PLUGINS");
        }
        IFeatureReference[] all = new IFeatureReference[configured.length + unconfigured.length];
        System.arraycopy(configured, 0, all, 0, configured.length);
        System.arraycopy(unconfigured, 0, all, configured.length, unconfigured.length);
        HashSet<FeaturePlugin> patchedPlugins = new HashSet<FeaturePlugin>();
        int i = 0;
        while (i < all.length) {
            try {
                IFeature feature = all[i].getFeature(null);
                if (feature == null) {
                    UpdateCore.warn("Null Feature", new Exception());
                } else {
                    IPluginEntry[] entries = feature.getPluginEntries();
                    int entr = 0;
                    while (entr < entries.length) {
                        patchedPlugins.add(new FeaturePlugin(entries[entr], feature));
                        ++entr;
                    }
                }
            }
            catch (CoreException e) {
                UpdateCore.warn(null, e);
            }
            ++i;
        }
        Set pluginStrings = this.getPluginStrings(site, patchedPlugins.toArray(new FeaturePlugin[patchedPlugins.size()]));
        return pluginStrings.toArray(new String[pluginStrings.size()]);
    }

    private Set getPluginStrings(ISite site, FeaturePlugin[] plugins) throws CoreException {
        HashSet<String> pluginStrings = new HashSet<String>();
        int i = 0;
        while (i < plugins.length) {
            IPluginEntry entry = plugins[i].getEntry();
            IFeature feature = plugins[i].getFeature();
            ContentReference[] featureContentReference = null;
            try {
                featureContentReference = feature.getFeatureContentProvider().getPluginEntryArchiveReferences(entry, null);
            }
            catch (CoreException e) {
                UpdateCore.warn(null, e);
            }
            if (featureContentReference != null) {
                int j = 0;
                while (j < featureContentReference.length) {
                    URL url = site.getSiteContentProvider().getArchiveReference(featureContentReference[j].getIdentifier());
                    if (url != null) {
                        String path = UpdateManagerUtils.getURLAsString(site.getURL(), url);
                        path = String.valueOf(path) + (path.endsWith(File.separator) || path.endsWith("/") ? "" : "/");
                        pluginStrings.add(path);
                        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                            UpdateCore.warn("Add plugin: " + path + " to the list");
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return pluginStrings;
    }

    private String[] subtract(String[] allStrings, String[] stringsToRemove) {
        HashSet<String> resultList = new HashSet<String>(Arrays.asList(allStrings));
        resultList.removeAll(Arrays.asList(stringsToRemove));
        return resultList.toArray(new String[resultList.size()]);
    }
}

