/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.quickdiff;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.ui.internal.texteditor.quickdiff.QuickDiffMessages;
import org.eclipse.ui.internal.texteditor.quickdiff.QuickDiffRestoreAction;
import org.eclipse.ui.texteditor.ITextEditor;

public class RevertLineAction
extends QuickDiffRestoreAction {
    private static final String PREFIX = "RevertLineAction.";
    private static final String DELETE_KEY = "RevertLineAction.delete.label";
    private static final String REVERT_KEY = "RevertLineAction.label";
    private int fLine;

    public RevertLineAction(ITextEditor editor, boolean isRulerAction) {
        super(QuickDiffMessages.getResourceBundle(), PREFIX, editor, isRulerAction);
    }

    public boolean computeEnablement() {
        if (!super.computeEnablement()) {
            return false;
        }
        this.fLine = this.getLastLine();
        if (this.fLine == -1) {
            return false;
        }
        ILineDiffer differ = this.getDiffer();
        if (differ == null) {
            return false;
        }
        ILineDiffInfo info = differ.getLineInfo(this.fLine);
        if (info == null || info.getChangeType() == 0) {
            return false;
        }
        if (info.getChangeType() == 1) {
            this.setText(QuickDiffMessages.getString(DELETE_KEY));
        } else {
            this.setText(QuickDiffMessages.getString(REVERT_KEY));
        }
        return true;
    }

    public void runCompoundChange() {
        if (!this.isEnabled()) {
            return;
        }
        ILineDiffer differ = this.getDiffer();
        if (differ != null) {
            try {
                differ.revertLine(this.fLine);
            }
            catch (BadLocationException e) {
                this.setStatus(e.getMessage());
            }
        }
    }
}

