/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.pde.internal.PDE;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CompilerFlags {
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int IGNORE = 2;
    public static final int MARKER = 0;
    public static final int BOOLEAN = 1;
    public static final int STRING = 2;
    public static final int PLUGIN_FLAGS = 0;
    public static final int SCHEMA_FLAGS = 1;
    public static final int FEATURE_FLAGS = 2;
    public static final int SITE_FLAGS = 3;
    public static final String USE_PROJECT_PREF = "compilers.use-project";
    public static final String P_UNRESOLVED_IMPORTS = "compilers.p.unresolved-import";
    public static final String P_UNRESOLVED_EX_POINTS = "compilers.p.unresolved-ex-points";
    public static final String P_UNKNOWN_ELEMENT = "compilers.p.unknown-element";
    public static final String P_UNKNOWN_ATTRIBUTE = "compilers.p.unknown-attribute";
    public static final String P_UNKNOWN_CLASS = "compilers.p.unknown-class";
    public static final String P_UNKNOWN_RESOURCE = "compilers.p.unknown-resource";
    public static final String P_NO_REQUIRED_ATT = "compilers.p.no-required-att";
    public static final String P_NOT_EXTERNALIZED = "compilers.p.not-externalized-att";
    public static final String P_DEPRECATED = "compilers.p.deprecated";
    public static final String S_CREATE_DOCS = "compilers.s.create-docs";
    public static final String S_DOC_FOLDER = "compilers.s.doc-folder";
    public static final String S_OPEN_TAGS = "compilers.s.open-tags";
    public static final String F_UNRESOLVED_PLUGINS = "compilers.f.unresolved-plugins";
    public static final String F_UNRESOLVED_FEATURES = "compilers.f.unresolved-features";
    private static final String[][] flags = new String[][]{{"compilers.p.unresolved-import", "compilers.p.unresolved-ex-points", "compilers.p.no-required-att", "compilers.p.unknown-element", "compilers.p.unknown-attribute", "compilers.p.deprecated", "compilers.p.unknown-class", "compilers.p.unknown-resource", "compilers.p.not-externalized-att"}, {"compilers.s.create-docs", "compilers.s.doc-folder", "compilers.s.open-tags"}, {"compilers.f.unresolved-plugins", "compilers.f.unresolved-features"}, new String[0]};

    public static int getFlagType(String flagId) {
        if (flagId.equals(S_CREATE_DOCS)) {
            return 1;
        }
        if (flagId.equals(S_DOC_FOLDER)) {
            return 2;
        }
        return 0;
    }

    public static int getFlag(IProject project, String flagId) {
        if (project == null) {
            return CompilerFlags.getFlag(null, flagId);
        }
        return CompilerFlags.getFlag(project.getName(), flagId);
    }

    private static int getFlag(String project, String flagId) {
        String value = CompilerFlags.getString(project, flagId);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static boolean getBoolean(IProject project, String flagId) {
        if (project == null) {
            return CompilerFlags.getBoolean(null, flagId);
        }
        return CompilerFlags.getBoolean(project.getName(), flagId);
    }

    private static boolean getBoolean(String project, String flagId) {
        String value = CompilerFlags.getString(project, flagId);
        return Boolean.valueOf(value);
    }

    public static String getString(IProject project, String flagId) {
        if (project == null) {
            return CompilerFlags.getString(null, flagId);
        }
        return CompilerFlags.getString(project.getName(), flagId);
    }

    private static String getString(String projectName, String flagId) {
        IPreferencesService service = Platform.getPreferencesService();
        IEclipsePreferences root = service.getRootNode();
        Preferences projectNode = null;
        if (projectName != null) {
            projectNode = root.node("project").node(projectName).node("org.eclipse.pde");
        }
        Preferences instanceNode = root.node("instance").node("org.eclipse.pde");
        Preferences defaultNode = root.node("default").node("org.eclipse.pde");
        Preferences[] nodes = projectNode != null ? new Preferences[]{projectNode, instanceNode, defaultNode} : new Preferences[]{instanceNode, defaultNode};
        return service.get(flagId, "", nodes);
    }

    public static int getDefaultFlag(String flagId) {
        org.eclipse.core.runtime.Preferences pref = PDE.getDefault().getPluginPreferences();
        return pref.getDefaultInt(flagId);
    }

    public static String getDefaultString(String flagId) {
        org.eclipse.core.runtime.Preferences pref = PDE.getDefault().getPluginPreferences();
        return pref.getDefaultString(flagId);
    }

    public static boolean getDefaultBoolean(String flagId) {
        org.eclipse.core.runtime.Preferences pref = PDE.getDefault().getPluginPreferences();
        return pref.getDefaultBoolean(flagId);
    }

    public static void setFlag(String flagId, int value) {
        org.eclipse.core.runtime.Preferences pref = PDE.getDefault().getPluginPreferences();
        pref.setValue(flagId, value);
    }

    public static void setFlag(IProject project, String flagId, int value) {
        CompilerFlags.setString(project, flagId, Integer.toString(value));
    }

    public static void setBoolean(String flagId, boolean value) {
        org.eclipse.core.runtime.Preferences pref = PDE.getDefault().getPluginPreferences();
        pref.setValue(flagId, value);
    }

    public static void setBoolean(IProject project, String flagId, boolean value) {
        CompilerFlags.setString(project, flagId, Boolean.toString(value));
    }

    public static void setString(String flagId, String value) {
        org.eclipse.core.runtime.Preferences pref = PDE.getDefault().getPluginPreferences();
        pref.setValue(flagId, value);
    }

    public static void setString(IProject project, String flagId, String value) {
        if (project == null) {
            return;
        }
        IPreferencesService service = Platform.getPreferencesService();
        IEclipsePreferences root = service.getRootNode();
        Preferences preferences = root.node("project").node(project.getName()).node("org.eclipse.pde");
        preferences.put(flagId, value);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static void clear(IProject project, String flagId) {
        if (project == null) {
            return;
        }
        IPreferencesService service = Platform.getPreferencesService();
        IEclipsePreferences root = service.getRootNode();
        Preferences preferences = root.node("project").node(project.getName()).node("org.eclipse.pde");
        preferences.remove(flagId);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static void initializeDefaults() {
        org.eclipse.core.runtime.Preferences pref = PDE.getDefault().getPluginPreferences();
        pref.setDefault(P_UNRESOLVED_IMPORTS, 0);
        pref.setDefault(P_UNRESOLVED_EX_POINTS, 0);
        pref.setDefault(P_NO_REQUIRED_ATT, 0);
        pref.setDefault(P_UNKNOWN_ELEMENT, 0);
        pref.setDefault(P_UNKNOWN_ATTRIBUTE, 0);
        pref.setDefault(P_UNKNOWN_CLASS, 2);
        pref.setDefault(P_UNKNOWN_RESOURCE, 2);
        pref.setDefault(P_NOT_EXTERNALIZED, 2);
        pref.setDefault(P_DEPRECATED, 1);
        pref.setDefault(S_CREATE_DOCS, false);
        pref.setDefault(S_DOC_FOLDER, "doc");
        pref.setDefault(S_OPEN_TAGS, 1);
        pref.setDefault(F_UNRESOLVED_PLUGINS, 1);
        pref.setDefault(F_UNRESOLVED_FEATURES, 1);
    }

    public static String[] getFlags(int group) {
        return flags[group];
    }

    public static void save() {
        PDE.getDefault().savePluginPreferences();
    }
}

