/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.builders.CompilerFlags;
import org.eclipse.pde.internal.builders.SchemaErrorReporter;
import org.eclipse.pde.internal.builders.SchemaTransformer;
import org.eclipse.pde.internal.builders.ValidatingSAXParser;
import org.eclipse.pde.internal.builders.XMLErrorReporter;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaDescriptor;
import org.w3c.dom.Node;

public class ExtensionPointSchemaBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDERS_SCHEMA_COMPILING = "Builders.Schema.compiling";
    public static final String BUILDERS_SCHEMA_COMPILING_SCHEMAS = "Builders.Schema.compilingSchemas";
    public static final String BUILDERS_UPDATING = "Builders.updating";
    public static final String BUILDERS_SCHEMA_REMOVING = "Builders.Schema.removing";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta = null;
        if (kind != 6) {
            delta = this.getDelta(this.getProject());
        }
        if (delta == null || kind == 6) {
            if (this.isInterestingProject(this.getProject())) {
                this.compileSchemasIn((IContainer)this.getProject(), monitor);
            }
        } else {
            delta.accept((IResourceDeltaVisitor)new DeltaVisitor(monitor));
        }
        return new IProject[0];
    }

    private boolean isInterestingProject(IProject project) {
        return PDE.hasPluginNature(project) && !WorkspaceModelManager.isBinaryPluginProject((IProject)project);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void compileFile(IFile file, IProgressMonitor monitor) {
        String message = PDE.getFormattedMessage(BUILDERS_SCHEMA_COMPILING, file.getFullPath().toString());
        monitor.subTask(message);
        SchemaErrorReporter reporter = new SchemaErrorReporter(file);
        ValidatingSAXParser.parse(file, (XMLErrorReporter)reporter);
        reporter.validateContent(monitor);
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        try {
            block10: {
                try {
                    boolean generateDoc = CompilerFlags.getBoolean(file.getProject(), "compilers.s.create-docs");
                    if (reporter.getDocumentRoot() == null || reporter.getErrorCount() != 0 || !generateDoc) break block10;
                    this.ensureFoldersExist(file.getProject(), this.getDocLocation(file));
                    String outputFileName = this.getOutputFileName(file);
                    IWorkspace workspace = file.getWorkspace();
                    Path outputPath = new Path(outputFileName);
                    SchemaDescriptor desc = new SchemaDescriptor(file, false);
                    Schema schema = (Schema)desc.getSchema(false);
                    schema.traverseDocumentTree((Node)reporter.getDocumentRoot());
                    SchemaTransformer transformer = new SchemaTransformer();
                    transformer.transform((ISchema)schema, writer);
                    ByteArrayInputStream target = new ByteArrayInputStream(swriter.toString().getBytes("UTF8"));
                    IFile outputFile = workspace.getRoot().getFile((IPath)outputPath);
                    if (!workspace.getRoot().exists((IPath)outputPath)) {
                        outputFile.create((InputStream)target, true, monitor);
                        break block10;
                    }
                    outputFile.setContents((InputStream)target, true, false, monitor);
                }
                catch (UnsupportedEncodingException e) {
                    PDE.logException(e);
                }
                catch (CoreException e) {
                    PDE.logException(e);
                }
            }
            Object var16_20 = null;
            writer.close();
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            writer.close();
            try {
                swriter.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        swriter.close();
        monitor.subTask(PDE.getResourceString(BUILDERS_UPDATING));
        monitor.done();
    }

    private void ensureFoldersExist(IProject project, String pathName) throws CoreException {
        Path path = new Path(pathName);
        IProject parent = project;
        int i = 0;
        while (i < path.segmentCount()) {
            String segment = path.segment(i);
            IFolder folder = parent.getFolder((IPath)new Path(segment));
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            parent = folder;
            ++i;
        }
    }

    private void compileSchemasIn(IContainer container, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(PDE.getResourceString(BUILDERS_SCHEMA_COMPILING_SCHEMAS));
        IResource[] members = container.members();
        int i = 0;
        while (i < members.length) {
            IResource member = members[i];
            if (member instanceof IContainer) {
                this.compileSchemasIn((IContainer)member, monitor);
            } else if (member instanceof IFile && this.isSchemaFile((IFile)member)) {
                this.compileFile((IFile)member, monitor);
            }
            ++i;
        }
        monitor.done();
    }

    private String getDocLocation(IFile file) {
        return CompilerFlags.getString(file.getProject(), "compilers.s.doc-folder");
    }

    private String getOutputFileName(IFile file) {
        String fileName = file.getName();
        int dot = fileName.lastIndexOf(46);
        String pageName = String.valueOf(fileName.substring(0, dot)) + ".html";
        String mangledPluginId = this.getMangledPluginId(file);
        if (mangledPluginId != null) {
            pageName = String.valueOf(mangledPluginId) + "_" + pageName;
        }
        IPath path = file.getProject().getFullPath().append(this.getDocLocation(file)).append(pageName);
        return path.toString();
    }

    private String getMangledPluginId(IFile file) {
        IPluginBase plugin;
        IProject project = file.getProject();
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(project);
        if (model instanceof IPluginModelBase && (plugin = model.getPluginBase()) != null) {
            return plugin.getId().replace('.', '_');
        }
        return null;
    }

    private boolean isSchemaFile(IFile file) {
        return "exsd".equals(file.getFileExtension());
    }

    private void removeOutputFile(IFile file, IProgressMonitor monitor) {
        IFile outputFile;
        String outputFileName = this.getOutputFileName(file);
        monitor.subTask(PDE.getFormattedMessage(BUILDERS_SCHEMA_REMOVING, outputFileName));
        IWorkspace workspace = file.getWorkspace();
        Path path = new Path(outputFileName);
        if (workspace.getRoot().exists((IPath)path) && (outputFile = workspace.getRoot().getFile((IPath)path)) != null) {
            try {
                outputFile.delete(true, true, monitor);
            }
            catch (CoreException e) {
                PDE.logException(e);
            }
        }
        monitor.done();
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        private IProgressMonitor monitor;

        public DeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) {
            IFile candidate;
            IResource resource = delta.getResource();
            if (resource instanceof IProject) {
                return ExtensionPointSchemaBuilder.this.isInterestingProject((IProject)resource);
            }
            if (resource instanceof IFolder) {
                return true;
            }
            if (resource instanceof IFile && ExtensionPointSchemaBuilder.this.isSchemaFile(candidate = (IFile)resource)) {
                if (delta.getKind() != 2) {
                    ExtensionPointSchemaBuilder.this.compileFile(candidate, this.monitor);
                } else {
                    ExtensionPointSchemaBuilder.this.removeOutputFile(candidate, this.monitor);
                }
            }
            return false;
        }
    }
}

