/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.Assert;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public class CompositeChange
extends Change {
    private String fName;
    private List fChanges;
    private boolean fIsSynthetic;
    private Change fUndoUntilException;

    public CompositeChange(String name) {
        this(name, new ArrayList(2));
    }

    public CompositeChange(String name, Change[] children) {
        this(name, new ArrayList(children.length));
        this.addAll(children);
    }

    private CompositeChange(String name, List changes) {
        Assert.isNotNull(changes);
        Assert.isNotNull(name);
        this.fChanges = changes;
        this.fName = name;
    }

    public boolean isSynthetic() {
        return this.fIsSynthetic;
    }

    public void markAsSynthetic() {
        this.fIsSynthetic = true;
    }

    public String getName() {
        return this.fName;
    }

    public void add(Change change) {
        if (change != null) {
            Assert.isTrue(change.getParent() == null);
            this.fChanges.add(change);
            change.setParent(this);
        }
    }

    public void addAll(Change[] changes) {
        int i = 0;
        while (i < changes.length) {
            this.add(changes[i]);
            ++i;
        }
    }

    public void merge(CompositeChange change) {
        Change[] others = change.getChildren();
        int i = 0;
        while (i < others.length) {
            Change other = others[i];
            change.remove(other);
            this.add(other);
            ++i;
        }
    }

    public boolean remove(Change change) {
        Assert.isNotNull(change);
        boolean result = this.fChanges.remove(change);
        if (result) {
            change.setParent(null);
        }
        return result;
    }

    public Change[] getChildren() {
        if (this.fChanges == null) {
            return null;
        }
        return this.fChanges.toArray(new Change[this.fChanges.size()]);
    }

    public void setEnabled(boolean enabled) {
        Iterator iter = this.fChanges.iterator();
        while (iter.hasNext()) {
            ((Change)iter.next()).setEnabled(enabled);
        }
    }

    public void initializeValidationData(IProgressMonitor pm) {
        pm.beginTask("", this.fChanges.size());
        Iterator iter = this.fChanges.iterator();
        while (iter.hasNext()) {
            Change change = (Change)iter.next();
            change.initializeValidationData((IProgressMonitor)new SubProgressMonitor(pm, 1));
            pm.worked(1);
        }
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("", this.fChanges.size());
        Iterator iter = this.fChanges.iterator();
        while (iter.hasNext() && !result.hasFatalError()) {
            Change change = (Change)iter.next();
            if (change.isEnabled()) {
                result.merge(change.isValid((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            } else {
                pm.worked(1);
            }
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        pm.done();
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        this.fUndoUntilException = null;
        ArrayList<Change> undos = new ArrayList<Change>(this.fChanges.size());
        pm.beginTask("", this.fChanges.size());
        pm.setTaskName(RefactoringCoreMessages.getString("CompositeChange.performingChangesTask.name"));
        Change change = null;
        try {
            Iterator iter = this.fChanges.iterator();
            while (iter.hasNext()) {
                change = (Change)iter.next();
                if (change.isEnabled()) {
                    Change undoChange = change.perform((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    if (undos != null) {
                        if (undoChange == null) {
                            undos = null;
                        } else {
                            undos.add(undoChange);
                        }
                    }
                }
                iter.remove();
                final Change changeToDispose = change;
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        changeToDispose.dispose();
                    }

                    public void handleException(Throwable exception) {
                        RefactoringCorePlugin.log(exception);
                    }
                });
            }
            if (undos != null) {
                Collections.reverse(undos);
                return this.createUndoChange(undos.toArray(new Change[undos.size()]));
            }
            return null;
        }
        catch (CoreException e) {
            this.handleUndos(change, undos);
            this.internalHandleException(change, e);
            throw e;
        }
        catch (RuntimeException e) {
            this.handleUndos(change, undos);
            this.internalHandleException(change, e);
            throw e;
        }
    }

    private void handleUndos(Change failedChange, List undos) {
        Change partUndoChange;
        if (undos == null) {
            this.fUndoUntilException = null;
            return;
        }
        if (failedChange instanceof CompositeChange && (partUndoChange = ((CompositeChange)failedChange).getUndoUntilException()) != null) {
            undos.add(partUndoChange);
        }
        if (undos.size() == 0) {
            this.fUndoUntilException = new NullChange(this.getName());
            return;
        }
        Collections.reverse(undos);
        this.fUndoUntilException = this.createUndoChange(undos.toArray(new Change[undos.size()]));
    }

    protected void internalHandleException(Change change, Throwable t) {
    }

    public void dispose() {
        Iterator iter = this.fChanges.iterator();
        while (iter.hasNext()) {
            final Change change = (Change)iter.next();
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    change.dispose();
                }

                public void handleException(Throwable exception) {
                    RefactoringCorePlugin.log(exception);
                }
            });
        }
    }

    public Change getUndoUntilException() {
        return this.fUndoUntilException;
    }

    protected Change createUndoChange(Change[] childUndos) {
        return new CompositeChange(this.getName(), childUndos);
    }

    public Object getModifiedElement() {
        return null;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getName());
        buff.append("\n");
        Iterator iter = this.fChanges.iterator();
        while (iter.hasNext()) {
            buff.append("<").append(iter.next().toString()).append("/>\n");
        }
        return buff.toString();
    }
}

