/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.Connection;
import Freeze.ConnectionI;
import Freeze.Evictor;
import Freeze.EvictorI;
import Freeze.FatalErrorCallback;
import Freeze.Index;
import Freeze.ServantInitializer;
import Ice.Communicator;
import Ice.ObjectAdapter;
import com.sleepycat.db.DbEnv;

public class Util {
    private static FatalErrorCallback _fatalErrorCallback = null;

    public static Evictor createEvictor(ObjectAdapter adapter, String envName, String filename, ServantInitializer initializer, Index[] indices, boolean createDb) {
        return new EvictorI(adapter, envName, filename, initializer, indices, createDb);
    }

    public static Evictor createEvictor(ObjectAdapter adapter, String envName, DbEnv dbEnv, String filename, ServantInitializer initializer, Index[] indices, boolean createDb) {
        return new EvictorI(adapter, envName, dbEnv, filename, initializer, indices, createDb);
    }

    public static Connection createConnection(Communicator communicator, String envName) {
        return new ConnectionI(communicator, envName);
    }

    public static Connection createConnection(Communicator communicator, String envName, DbEnv dbEnv) {
        return new ConnectionI(communicator, envName, dbEnv);
    }

    public static synchronized FatalErrorCallback registerFatalErrorCallback(FatalErrorCallback cb) {
        FatalErrorCallback result = _fatalErrorCallback;
        _fatalErrorCallback = cb;
        return result;
    }

    static synchronized void handleFatalError(Evictor evictor, Communicator communicator, RuntimeException ex) {
        if (_fatalErrorCallback != null) {
            _fatalErrorCallback.handleError(evictor, communicator, ex);
        } else {
            communicator.getLogger().error("*** Halting JVM ***");
            Runtime.getRuntime().halt(1);
        }
    }
}

