/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.LocalObjectImpl;
import Ice.NotRegisteredException;
import Ice.Plugin;
import Ice.PluginFactory;
import Ice.PluginInitializationException;
import Ice.PluginManager;
import Ice.Properties;
import Ice.StringSeqHolder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class PluginManagerI
extends LocalObjectImpl
implements PluginManager {
    private static String _kindOfObject;
    private Communicator _communicator;
    private HashMap _plugins = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public synchronized Plugin getPlugin(String name) {
        if (this._communicator == null) {
            throw new CommunicatorDestroyedException();
        }
        Plugin p = (Plugin)this._plugins.get(name);
        if (p != null) {
            return p;
        }
        NotRegisteredException ex = new NotRegisteredException();
        ex.id = name;
        ex.kindOfObject = _kindOfObject;
        throw ex;
    }

    public synchronized void addPlugin(String name, Plugin plugin) {
        if (this._communicator == null) {
            throw new CommunicatorDestroyedException();
        }
        if (this._plugins.containsKey(name)) {
            AlreadyRegisteredException ex = new AlreadyRegisteredException();
            ex.id = name;
            ex.kindOfObject = _kindOfObject;
            throw ex;
        }
        this._plugins.put(name, plugin);
    }

    public synchronized void destroy() {
        if (this._communicator != null) {
            Iterator i = this._plugins.values().iterator();
            while (i.hasNext()) {
                Plugin p = (Plugin)i.next();
                p.destroy();
            }
            this._communicator = null;
        }
    }

    public PluginManagerI(Communicator communicator) {
        this._communicator = communicator;
    }

    public void loadPlugins(StringSeqHolder cmdArgs) {
        if (!$assertionsDisabled && this._communicator == null) {
            throw new AssertionError();
        }
        String prefix = "Ice.Plugin.";
        Properties properties = this._communicator.getProperties();
        Map plugins = properties.getPropertiesForPrefix("Ice.Plugin.");
        Iterator p = plugins.entrySet().iterator();
        while (p.hasNext()) {
            String[] args;
            String className;
            Map.Entry entry = p.next();
            String name = ((String)entry.getKey()).substring("Ice.Plugin.".length());
            String value = (String)entry.getValue();
            int pos = value.indexOf(32);
            if (pos == -1) {
                pos = value.indexOf(9);
            }
            if (pos == -1) {
                pos = value.indexOf(10);
            }
            if (pos == -1) {
                className = value;
                args = new String[]{};
            } else {
                className = value.substring(0, pos);
                args = value.substring(pos).trim().split("[ \t\n]+", pos);
            }
            args = properties.parseCommandLineOptions(name, args);
            cmdArgs.value = properties.parseCommandLineOptions(name, cmdArgs.value);
            this.loadPlugin(name, className, args);
        }
    }

    private void loadPlugin(String name, String className, String[] args) {
        if (!$assertionsDisabled && this._communicator == null) {
            throw new AssertionError();
        }
        PluginFactory factory = null;
        try {
            Class<?> c = Class.forName(className);
            Object obj = c.newInstance();
            try {
                factory = (PluginFactory)obj;
            }
            catch (ClassCastException ex) {
                PluginInitializationException e = new PluginInitializationException();
                e.reason = "class " + className + " does not implement Ice.PluginFactory";
                e.initCause(ex);
                throw e;
            }
        }
        catch (ClassNotFoundException ex) {
            PluginInitializationException e = new PluginInitializationException();
            e.reason = "class " + className + " not found";
            e.initCause(ex);
            throw e;
        }
        catch (IllegalAccessException ex) {
            PluginInitializationException e = new PluginInitializationException();
            e.reason = "unable to access default constructor in class " + className;
            e.initCause(ex);
            throw e;
        }
        catch (InstantiationException ex) {
            PluginInitializationException e = new PluginInitializationException();
            e.reason = "unable to instantiate class " + className;
            e.initCause(ex);
            throw e;
        }
        Plugin plugin = null;
        try {
            plugin = factory.create(this._communicator, name, args);
        }
        catch (Exception ex) {
            PluginInitializationException e = new PluginInitializationException();
            e.reason = "exception in factory " + className;
            e.initCause(ex);
            throw e;
        }
        this._plugins.put(name, plugin);
    }

    static {
        $assertionsDisabled = !PluginManagerI.class.desiredAssertionStatus();
        _kindOfObject = "plug-in";
    }
}

