/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import Ice.Identity;
import Ice.IllegalIdentityException;
import Ice.LocatorPrx;
import Ice.ObjectAdapter;
import Ice.ProxyParseException;
import Ice.ProxyUnmarshalException;
import Ice.RouterPrx;
import Ice.StringHolder;
import Ice.Util;
import IceInternal.BasicStream;
import IceInternal.Endpoint;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.Reference;
import IceInternal.RouterInfo;
import IceUtil.StringUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class ReferenceFactory {
    private Instance _instance;
    private RouterPrx _defaultRouter;
    private LocatorPrx _defaultLocator;
    private WeakHashMap _references = new WeakHashMap();

    public synchronized Reference create(Identity ident, Map context, String facet, int mode, boolean secure, String adapterId, Endpoint[] endpoints, RouterInfo routerInfo, LocatorInfo locatorInfo, ObjectAdapter reverseAdapter, boolean collocationOptimization) {
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        Reference ref = new Reference(this._instance, ident, context, facet, mode, secure, adapterId, endpoints, routerInfo, locatorInfo, reverseAdapter, collocationOptimization);
        WeakReference w = (WeakReference)this._references.get(ref);
        if (w != null) {
            Reference r = (Reference)w.get();
            if (r != null) {
                ref = r;
            } else {
                this._references.put(ref, new WeakReference<Reference>(ref));
            }
        } else {
            this._references.put(ref, new WeakReference<Reference>(ref));
        }
        return ref;
    }

    public Reference create(String s) {
        ProxyParseException e;
        if (s.length() == 0) {
            return null;
        }
        String delim = " \t\n\r";
        int end = 0;
        int beg = StringUtil.findFirstNotOf(s, " \t\n\r", end);
        if (beg == -1) {
            ProxyParseException e2 = new ProxyParseException();
            e2.str = s;
            throw e2;
        }
        String idstr = null;
        end = StringUtil.checkQuote(s, beg);
        if (end == -1) {
            ProxyParseException e3 = new ProxyParseException();
            e3.str = s;
            throw e3;
        }
        if (end == 0) {
            end = StringUtil.findFirstOf(s, " \t\n\r:@", beg);
            if (end == -1) {
                end = s.length();
            }
            idstr = s.substring(beg, end);
        } else {
            idstr = s.substring(++beg, end);
            ++end;
        }
        if (beg == end) {
            ProxyParseException e4 = new ProxyParseException();
            e4.str = s;
            throw e4;
        }
        Identity ident = Util.stringToIdentity(idstr);
        if (ident.name.length() == 0) {
            if (ident.category.length() > 0) {
                IllegalIdentityException e5 = new IllegalIdentityException();
                e5.id = ident;
                throw e5;
            }
            if (StringUtil.findFirstNotOf(s, " \t\n\r", end) != -1) {
                ProxyParseException e6 = new ProxyParseException();
                e6.str = s;
                throw e6;
            }
            return null;
        }
        String facet = "";
        int mode = 0;
        boolean secure = false;
        String adapter = "";
        block9: while ((beg = StringUtil.findFirstNotOf(s, " \t\n\r", end)) != -1 && s.charAt(beg) != ':' && s.charAt(beg) != '@') {
            char ch;
            end = StringUtil.findFirstOf(s, " \t\n\r:@", beg);
            if (end == -1) {
                end = s.length();
            }
            if (beg == end) break;
            String option = s.substring(beg, end);
            if (option.length() != 2 || option.charAt(0) != '-') {
                e = new ProxyParseException();
                e.str = s;
                throw e;
            }
            String argument = null;
            int argumentBeg = StringUtil.findFirstNotOf(s, " \t\n\r", end);
            if (argumentBeg != -1 && (ch = s.charAt(argumentBeg)) != '@' && ch != ':' && ch != '-') {
                beg = argumentBeg;
                end = StringUtil.checkQuote(s, beg);
                if (end == -1) {
                    ProxyParseException e7 = new ProxyParseException();
                    e7.str = s;
                    throw e7;
                }
                if (end == 0) {
                    end = StringUtil.findFirstOf(s, " \t\n\r:@", beg);
                    if (end == -1) {
                        end = s.length();
                    }
                    argument = s.substring(beg, end);
                } else {
                    argument = s.substring(++beg, end);
                    ++end;
                }
            }
            switch (option.charAt(1)) {
                case 'f': {
                    if (argument == null) {
                        ProxyParseException e8 = new ProxyParseException();
                        e8.str = s;
                        throw e8;
                    }
                    StringHolder facetH = new StringHolder();
                    if (!StringUtil.unescapeString(argument, 0, argument.length(), facetH)) {
                        ProxyParseException e9 = new ProxyParseException();
                        e9.str = s;
                        throw e9;
                    }
                    facet = facetH.value;
                    continue block9;
                }
                case 't': {
                    if (argument != null) {
                        ProxyParseException e10 = new ProxyParseException();
                        e10.str = s;
                        throw e10;
                    }
                    mode = 0;
                    continue block9;
                }
                case 'o': {
                    if (argument != null) {
                        ProxyParseException e11 = new ProxyParseException();
                        e11.str = s;
                        throw e11;
                    }
                    mode = 1;
                    continue block9;
                }
                case 'O': {
                    if (argument != null) {
                        ProxyParseException e12 = new ProxyParseException();
                        e12.str = s;
                        throw e12;
                    }
                    mode = 2;
                    continue block9;
                }
                case 'd': {
                    if (argument != null) {
                        ProxyParseException e13 = new ProxyParseException();
                        e13.str = s;
                        throw e13;
                    }
                    mode = 3;
                    continue block9;
                }
                case 'D': {
                    if (argument != null) {
                        ProxyParseException e14 = new ProxyParseException();
                        e14.str = s;
                        throw e14;
                    }
                    mode = 4;
                    continue block9;
                }
                case 's': {
                    if (argument != null) {
                        ProxyParseException e15 = new ProxyParseException();
                        e15.str = s;
                        throw e15;
                    }
                    secure = true;
                    continue block9;
                }
            }
            ProxyParseException e16 = new ProxyParseException();
            e16.str = s;
            throw e16;
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        if (beg != -1) {
            if (s.charAt(beg) == ':') {
                end = beg;
                while (end < s.length() && s.charAt(end) == ':') {
                    beg = end + 1;
                    if ((end = s.indexOf(58, beg)) == -1) {
                        end = s.length();
                    }
                    String es = s.substring(beg, end);
                    Endpoint endp = this._instance.endpointFactoryManager().create(es);
                    endpoints.add(endp);
                }
            } else if (s.charAt(beg) == '@') {
                StringHolder token;
                if ((beg = StringUtil.findFirstNotOf(s, " \t\n\r", beg + 1)) == -1) {
                    e = new ProxyParseException();
                    e.str = s;
                    throw e;
                }
                end = StringUtil.checkQuote(s, beg);
                if (end == -1) {
                    e = new ProxyParseException();
                    e.str = s;
                    throw e;
                }
                if (end == 0) {
                    end = StringUtil.findFirstOf(s, " \t\n\r", beg);
                    if (end == -1) {
                        end = s.length();
                    }
                } else {
                    ++beg;
                }
                if (!StringUtil.unescapeString(s, beg, end, token = new StringHolder()) || token.value.length() == 0) {
                    ProxyParseException e17 = new ProxyParseException();
                    e17.str = s;
                    throw e17;
                }
                adapter = token.value;
            }
        }
        Endpoint[] endp = new Endpoint[endpoints.size()];
        endpoints.toArray(endp);
        RouterInfo routerInfo = this._instance.routerManager().get(this.getDefaultRouter());
        LocatorInfo locatorInfo = this._instance.locatorManager().get(this.getDefaultLocator());
        return this.create(ident, new HashMap(), facet, mode, secure, adapter, endp, routerInfo, locatorInfo, null, true);
    }

    public Reference create(Identity ident, BasicStream s) {
        Endpoint[] endpoints;
        String facet;
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        String[] facetPath = s.readStringSeq();
        if (facetPath.length > 0) {
            if (facetPath.length > 1) {
                throw new ProxyUnmarshalException();
            }
            facet = facetPath[0];
        } else {
            facet = "";
        }
        byte mode = s.readByte();
        if (mode < 0 || mode > 4) {
            throw new ProxyUnmarshalException();
        }
        boolean secure = s.readBool();
        String adapterId = "";
        int sz = s.readSize();
        if (sz > 0) {
            endpoints = new Endpoint[sz];
            for (int i = 0; i < sz; ++i) {
                endpoints[i] = this._instance.endpointFactoryManager().read(s);
            }
        } else {
            endpoints = new Endpoint[]{};
            adapterId = s.readString();
        }
        RouterInfo routerInfo = this._instance.routerManager().get(this.getDefaultRouter());
        LocatorInfo locatorInfo = this._instance.locatorManager().get(this.getDefaultLocator());
        return this.create(ident, new HashMap(), facet, mode, secure, adapterId, endpoints, routerInfo, locatorInfo, null, true);
    }

    public synchronized void setDefaultRouter(RouterPrx defaultRouter) {
        this._defaultRouter = defaultRouter;
    }

    public synchronized RouterPrx getDefaultRouter() {
        return this._defaultRouter;
    }

    public synchronized void setDefaultLocator(LocatorPrx defaultLocator) {
        this._defaultLocator = defaultLocator;
    }

    public synchronized LocatorPrx getDefaultLocator() {
        return this._defaultLocator;
    }

    ReferenceFactory(Instance instance) {
        this._instance = instance;
    }

    synchronized void destroy() {
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        this._instance = null;
        this._defaultRouter = null;
        this._defaultLocator = null;
        this._references.clear();
    }
}

