/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionLostException;
import Ice.Logger;
import Ice.SocketException;
import Ice.Stats;
import Ice.TimeoutException;
import IceInternal.BasicStream;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

final class TcpTransceiver
implements Transceiver {
    private SocketChannel _fd;
    private TraceLevels _traceLevels;
    private Logger _logger;
    private Stats _stats;
    private String _desc;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SelectableChannel fd() {
        if (!$assertionsDisabled && this._fd == null) {
            throw new AssertionError();
        }
        return this._fd;
    }

    public void close() {
        if (this._traceLevels.network >= 1) {
            String s = "closing tcp connection\n" + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        if (!$assertionsDisabled && this._fd == null) {
            throw new AssertionError();
        }
        try {
            this._fd.close();
            this._fd = null;
        }
        catch (IOException ex) {
            this._fd = null;
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public void shutdown() {
        if (this._traceLevels.network >= 2) {
            String s = "shutting down tcp connection\n" + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        if (!$assertionsDisabled && this._fd == null) {
            throw new AssertionError();
        }
        Socket socket = this._fd.socket();
        try {
            socket.shutdownOutput();
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(BasicStream stream, int timeout) {
        ByteBuffer buf = stream.prepareWrite();
        Selector selector = null;
        try {
            while (buf.hasRemaining()) {
                try {
                    if (!$assertionsDisabled && this._fd == null) {
                        throw new AssertionError();
                    }
                    int ret = this._fd.write(buf);
                    if (ret == -1) {
                        throw new ConnectionLostException();
                    }
                    if (ret == 0) {
                        if (timeout == 0) {
                            throw new TimeoutException();
                        }
                        if (selector == null) {
                            selector = Selector.open();
                            this._fd.register(selector, 4, null);
                        }
                        try {
                            if (timeout > 0) {
                                long start = System.currentTimeMillis();
                                int n = selector.select(timeout);
                                if (n != 0 || System.currentTimeMillis() < start + (long)timeout) continue;
                                throw new TimeoutException();
                            }
                            selector.select();
                            continue;
                        }
                        catch (InterruptedIOException ex) {
                            continue;
                        }
                    }
                    if (this._traceLevels.network >= 3) {
                        String s = "sent " + ret + " of " + buf.limit() + " bytes via tcp\n" + this.toString();
                        this._logger.trace(this._traceLevels.networkCat, s);
                    }
                    if (this._stats == null) continue;
                    this._stats.bytesSent("tcp", ret);
                }
                catch (InterruptedIOException ex) {
                }
                catch (IOException ex) {
                    SocketException se = new SocketException();
                    se.initCause(ex);
                    throw se;
                }
            }
            Object var10_13 = null;
            if (selector == null) return;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (selector == null) throw throwable;
            try {
                selector.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ex) {
            return;
        }
        selector.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(BasicStream stream, int timeout) {
        ByteBuffer buf = stream.prepareRead();
        int remaining = 0;
        if (this._traceLevels.network >= 3) {
            remaining = buf.remaining();
        }
        Selector selector = null;
        try {
            while (buf.hasRemaining()) {
                try {
                    if (!$assertionsDisabled && this._fd == null) {
                        throw new AssertionError();
                    }
                    int ret = this._fd.read(buf);
                    if (ret == -1) {
                        throw new ConnectionLostException();
                    }
                    if (ret == 0) {
                        if (timeout == 0) {
                            throw new TimeoutException();
                        }
                        if (selector == null) {
                            selector = Selector.open();
                            this._fd.register(selector, 1, null);
                        }
                        try {
                            if (timeout > 0) {
                                long start = System.currentTimeMillis();
                                int n = selector.select(timeout);
                                if (n != 0 || System.currentTimeMillis() < start + (long)timeout) continue;
                                throw new TimeoutException();
                            }
                            selector.select();
                            continue;
                        }
                        catch (InterruptedIOException ex) {
                            continue;
                        }
                    }
                    if (ret <= 0) continue;
                    if (this._traceLevels.network >= 3) {
                        String s = "received " + ret + " of " + remaining + " bytes via tcp\n" + this.toString();
                        this._logger.trace(this._traceLevels.networkCat, s);
                    }
                    if (this._stats == null) continue;
                    this._stats.bytesReceived("tcp", ret);
                }
                catch (InterruptedIOException ex) {
                }
                catch (IOException ex) {
                    if (Network.connectionLost(ex)) {
                        ConnectionLostException se = new ConnectionLostException();
                        se.initCause(ex);
                        throw se;
                    }
                    SocketException se = new SocketException();
                    se.initCause(ex);
                    throw se;
                }
            }
            Object var11_15 = null;
            if (selector == null) return;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (selector == null) throw throwable;
            try {
                selector.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ex) {
            return;
        }
        selector.close();
    }

    public String toString() {
        return this._desc;
    }

    TcpTransceiver(Instance instance, SocketChannel fd) {
        this._fd = fd;
        this._traceLevels = instance.traceLevels();
        this._logger = instance.logger();
        this._stats = instance.stats();
        this._desc = Network.fdToString(this._fd);
    }

    protected void finalize() throws Throwable {
        if (!$assertionsDisabled && this._fd != null) {
            throw new AssertionError();
        }
        super.finalize();
    }

    static {
        $assertionsDisabled = !TcpTransceiver.class.desiredAssertionStatus();
    }
}

