/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.run;

import java.util.Enumeration;
import java.util.ResourceBundle;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.JobControl;
import uk.ac.sanger.jcon.dao.JobDAO;
import uk.ac.sanger.jcon.dao.StatusDAO;
import uk.ac.sanger.jcon.run.AbstractCoordinator;
import uk.ac.sanger.jcon.run.ProcessorFactory;

public class CoordinatorDefaultImpl
extends AbstractCoordinator
implements Runnable {
    public static final int DEFAULT_MAX_CONCURRENT = 20;
    public static final int DEFAULT_GRAB_SIZE = 10;
    public static final int DEFAULT_POLL_INTERVAL = 60000;
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$run$CoordinatorDefaultImpl == null ? (class$uk$ac$sanger$jcon$run$CoordinatorDefaultImpl = CoordinatorDefaultImpl.class$("uk.ac.sanger.jcon.run.CoordinatorDefaultImpl")) : class$uk$ac$sanger$jcon$run$CoordinatorDefaultImpl).getName());
    private Thread thread;
    static /* synthetic */ Class class$uk$ac$sanger$jcon$run$CoordinatorDefaultImpl;

    public CoordinatorDefaultImpl(ProcessorFactory pFactory, JobDAO jobDAO, StatusDAO statusDAO) {
        super(pFactory, jobDAO, statusDAO);
        this.maxConcurrentJobs = 20;
        this.jobGrabSize = 10;
        this.jobPollInterval = 60000;
        ResourceBundle bundle = JobControl.getConfiguration();
        try {
            Enumeration<String> e = bundle.getKeys();
            while (e.hasMoreElements()) {
                String val;
                String key = e.nextElement();
                try {
                    val = bundle.getString(key);
                }
                catch (NullPointerException npe) {
                    throw new Error("Malformed configuration ResourceBundle contains key '" + key + "' missing a corresponding value");
                }
                if (key.equals("jobcontrol.coordinator.max_concurrent")) {
                    this.maxConcurrentJobs = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("jobcontrol.coordinator.grab_size")) {
                    this.jobGrabSize = Integer.parseInt(val);
                    continue;
                }
                if (!key.equals("jobcontrol.coordinator.poll_interval")) continue;
                this.jobPollInterval = Integer.parseInt(val);
            }
        }
        catch (NumberFormatException nfe) {
            throw new Error("Number format error in configuration ResourceBundle");
        }
        this.thread = new Thread(this);
    }

    public void startCoordinating() throws IllegalStateException {
        if (this.isCoordinating) {
            throw new IllegalStateException("Coordinator is already running");
        }
        this.isCoordinating = true;
        this.stopRequested = false;
        this.createProcessors();
        cat.info((Object)"Job execution Coordinator started");
        this.thread.start();
    }

    public void stopCoordinating() throws IllegalStateException {
        if (!this.isCoordinating) {
            throw new IllegalStateException("Coordinator is already stopped");
        }
        this.stopRequested = true;
        cat.info((Object)"Job execution Coordinator stop requested");
    }

    public void run() {
        this.coordinate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

