/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry;

import org.eclipse.jface.action.Action;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowser;

public class TogglePropertiesAction
extends Action {
    public static final String SHOW_PROPERTIES_SHEET = "RegistryView.showPropertiesSheet.label";
    public static final String SHOW_PROPERTIES_SHEET_TOOLTIP = "RegistryView.showPropertiesSheet.tooltip";
    public static final String SHOW_PROPERTIES_SHEET_DESC = "RegistryView.showPropertiesSheet.desc";
    public static final String USE_VERTICAL_ORIENTATION = "RegistryView.verticalOrientation.label";
    public static final String USE_VERTICAL_ORIENTATION_TOOLTIP = "RegistryView.verticalOrientation.tooltip";
    public static final String USE_VERTICAL_ORIENTATION_DESC = "RegistryView.verticalOrientation.desc";
    public static final String USE_HORIZONTAL_ORIENTATION = "RegistryView.horizontalOrientation.label";
    public static final String USE_HORIZONTAL_ORIENTATION_TOOLTIP = "RegistryView.horizontalOrientation.tooltip";
    public static final String USE_HORIZONTAL_ORIENTATION_DESC = "RegistryView.horizontalOrientation.desc";
    private RegistryBrowser fViewer;
    private int fOrientation;

    public TogglePropertiesAction(RegistryBrowser view, int orientation) {
        super("", 8);
        this.setRegistryBrowser(view);
        this.setOrientation(orientation);
        if (orientation == 1) {
            this.setText(PDERuntimePlugin.getResourceString(USE_VERTICAL_ORIENTATION));
            this.setToolTipText(PDERuntimePlugin.getResourceString(USE_VERTICAL_ORIENTATION_TOOLTIP));
            this.setDescription(PDERuntimePlugin.getResourceString(USE_VERTICAL_ORIENTATION_DESC));
            this.setImageDescriptor(PDERuntimePluginImages.DESC_VERTICAL_VIEW);
            this.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_VERTICAL_VIEW_DISABLED);
        } else if (orientation == 2) {
            this.setText(PDERuntimePlugin.getResourceString(USE_HORIZONTAL_ORIENTATION));
            this.setToolTipText(PDERuntimePlugin.getResourceString(USE_HORIZONTAL_ORIENTATION_TOOLTIP));
            this.setDescription(PDERuntimePlugin.getResourceString(USE_HORIZONTAL_ORIENTATION_DESC));
            this.setImageDescriptor(PDERuntimePluginImages.DESC_HORIZONTAL_VIEW);
            this.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_HORIZONTAL_VIEW_DISABLED);
        } else {
            this.setText(PDERuntimePlugin.getResourceString(SHOW_PROPERTIES_SHEET));
            this.setToolTipText(PDERuntimePlugin.getResourceString(SHOW_PROPERTIES_SHEET_TOOLTIP));
            this.setDescription(PDERuntimePlugin.getResourceString(SHOW_PROPERTIES_SHEET_DESC));
            this.setImageDescriptor(PDERuntimePluginImages.DESC_HIDE_PANE);
        }
    }

    public void run() {
        this.getRegistryBrowser().setViewOrientation(this.getOrientation());
    }

    private RegistryBrowser getRegistryBrowser() {
        return this.fViewer;
    }

    private void setRegistryBrowser(RegistryBrowser view) {
        this.fViewer = view;
    }

    private void setOrientation(int orientation) {
        this.fOrientation = orientation;
    }

    public int getOrientation() {
        return this.fOrientation;
    }
}

