/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.service.datalocation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.adaptor.BasicLocation;
import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.adaptor.Locker;

public class FileManager {
    private File base;
    private File managerRoot;
    private String lockMode = null;
    private File tableFile = null;
    private File lockFile;
    private Locker locker;
    private File instanceFile = null;
    private Locker instanceLocker = null;
    private long tableStamp = 0L;
    private Properties table = new Properties();
    private static final String MANAGER_FOLDER = ".manager";
    private static final String TABLE_FILE = ".fileTable";
    private static final String LOCK_FILE = ".fileTableLock";

    public FileManager(File base, String lockMode) {
        this.base = base;
        this.lockMode = lockMode;
        this.managerRoot = new File(base, MANAGER_FOLDER);
        this.managerRoot.mkdir();
        this.tableFile = new File(this.managerRoot, TABLE_FILE);
        this.lockFile = new File(this.managerRoot, LOCK_FILE);
    }

    private void initializeInstanceFile() throws IOException {
        if (this.instanceFile != null) {
            return;
        }
        this.instanceFile = File.createTempFile(".tmp", ".instance", this.managerRoot);
        this.instanceFile.deleteOnExit();
        this.instanceLocker = BasicLocation.createLocker(this.instanceFile, this.lockMode);
        this.instanceLocker.lock();
    }

    private String getAbsolutePath(String file) {
        return new File(this.base, file).getAbsolutePath();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(String file) throws IOException {
        if (!this.lock()) {
            throw new IOException(EclipseAdaptorMsg.formatter.getString("fileManager.cannotLock"));
        }
        try {
            this.updateTable();
            Entry entry = (Entry)this.table.get(file);
            if (entry == null) {
                this.table.put(file, new Entry(0, 1));
                this.save();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.release();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.release();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(String[] targets, String[] sources) throws IOException {
        if (!this.lock()) {
            throw new IOException(EclipseAdaptorMsg.formatter.getString("fileManager.cannotLock"));
        }
        try {
            this.updateTable();
            int i = 0;
            while (true) {
                block5: {
                    if (i < targets.length) break block5;
                    this.save();
                    break;
                }
                String target = targets[i];
                this.update(target, sources[i]);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.release();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.release();
            return;
        }
    }

    public String[] getFiles() {
        Set<Object> set = this.table.keySet();
        String[] keys = set.toArray(new String[set.size()]);
        String[] result = new String[keys.length];
        int i = 0;
        while (i < keys.length) {
            result[i] = new String(keys[i]);
            ++i;
        }
        return result;
    }

    public File getBase() {
        return this.base;
    }

    public int getId(String target) {
        Entry entry = (Entry)this.table.get(target);
        if (entry == null) {
            return -1;
        }
        return entry.getReadId();
    }

    private boolean lock() throws IOException {
        if (this.locker == null) {
            this.locker = BasicLocation.createLocker(this.lockFile, this.lockMode);
        }
        if (this.locker == null) {
            throw new IOException(EclipseAdaptorMsg.formatter.getString("fileManager.cannotLock"));
        }
        return this.locker.lock();
    }

    public File lookup(String target, boolean add) throws IOException {
        Entry entry = (Entry)this.table.get(target);
        if (entry == null) {
            if (add) {
                this.add(target);
                entry = (Entry)this.table.get(target);
            } else {
                return null;
            }
        }
        return new File(this.getAbsolutePath(String.valueOf(target) + '.' + entry.getReadId()));
    }

    private void move(String source, String target) {
        File original = new File(source);
        if (!original.exists()) {
            return;
        }
        original.renameTo(new File(target));
    }

    private void release() {
        if (this.locker == null) {
            return;
        }
        this.locker.release();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(String file) throws IOException {
        if (!this.lock()) {
            throw new IOException(EclipseAdaptorMsg.formatter.getString("fileManager.cannotLock"));
        }
        try {
            this.updateTable();
            this.table.remove(file);
            this.save();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.release();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.release();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateTable() throws IOException {
        if (!this.tableFile.exists()) {
            return;
        }
        long stamp = this.tableFile.lastModified();
        if (stamp == this.tableStamp) {
            return;
        }
        this.initializeInstanceFile();
        Properties diskTable = new Properties();
        FileInputStream input = new FileInputStream(this.tableFile);
        try {
            diskTable.load(input);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            input.close();
            throw throwable;
        }
        {
            Object var5_8 = null;
            input.close();
        }
        this.tableStamp = stamp;
        Enumeration<Object> e = diskTable.keys();
        while (e.hasMoreElements()) {
            String file = (String)e.nextElement();
            String readNumber = diskTable.getProperty(file);
            if (readNumber == null) continue;
            Entry entry = (Entry)this.table.get(file);
            int id = Integer.parseInt(readNumber);
            if (entry == null) {
                this.table.put(file, new Entry(id, id + 1));
                continue;
            }
            entry.setWriteId(id + 1);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void save() throws IOException {
        if (this.tableStamp != this.tableFile.lastModified()) {
            this.updateTable();
        }
        Properties props = new Properties();
        Enumeration<Object> e = this.table.keys();
        while (e.hasMoreElements()) {
            String file = (String)e.nextElement();
            Entry entry = (Entry)this.table.get(file);
            String value = Integer.toString(entry.getWriteId() - 1);
            props.put(file, value);
        }
        FileOutputStream fileStream = new FileOutputStream(this.tableFile);
        try {
            Object var3_3;
            try {
                props.store(fileStream, "safe table");
                var3_3 = null;
            }
            catch (Throwable throwable) {
                var3_3 = null;
                fileStream.close();
                throw throwable;
            }
            fileStream.close();
            return;
        }
        catch (IOException iOException) {
            throw new IOException(EclipseAdaptorMsg.formatter.getString("fileManager.couldNotSave"));
        }
    }

    private void update(String target, String source) {
        Entry entry = (Entry)this.table.get(target);
        int newId = entry.getWriteId();
        this.move(this.getAbsolutePath(source), String.valueOf(this.getAbsolutePath(target)) + '.' + newId);
        entry.setReadId(newId);
        entry.setWriteId(newId + 1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanup() throws IOException {
        String[] files = this.managerRoot.list();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".instance") && this.instanceFile != null && !files[i].equalsIgnoreCase(this.instanceFile.getName())) {
                    Locker tmpLocker = BasicLocation.createLocker(new File(this.managerRoot, files[i]), this.lockMode);
                    if (!tmpLocker.lock()) {
                        tmpLocker.release();
                        return;
                    }
                    new File(this.managerRoot, files[i]).delete();
                    tmpLocker.release();
                }
                ++i;
            }
        }
        if (!this.lock()) {
            throw new IOException(EclipseAdaptorMsg.formatter.getString("fileManager.cannotLock"));
        }
        try {
            this.updateTable();
            Set<Map.Entry<Object, Object>> managedFiles = this.table.entrySet();
            Iterator iter = managedFiles.iterator();
            while (iter.hasNext()) {
                Map.Entry fileEntry = (Map.Entry)iter.next();
                String fileName = (String)fileEntry.getKey();
                Entry info = (Entry)fileEntry.getValue();
                String readId = Integer.toString(info.getWriteId() - 1);
                this.deleteCopies(fileName, readId);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.release();
            throw throwable;
        }
        {
            Object var8_12 = null;
            this.release();
            return;
        }
    }

    private void deleteCopies(String fileName, String exceptionNumber) {
        String notToDelete = String.valueOf(fileName) + '.' + exceptionNumber;
        String[] files = this.base.list();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].startsWith(String.valueOf(fileName) + '.') && !files[i].equals(notToDelete)) {
                new File(this.base, files[i]).delete();
            }
            ++i;
        }
    }

    public void close() {
        try {
            this.cleanup();
        }
        catch (IOException iOException) {}
        if (this.instanceLocker != null) {
            this.instanceLocker.release();
        }
        if (this.instanceFile != null) {
            this.instanceFile.delete();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(boolean wait) throws IOException {
        boolean locked = this.lock();
        if (!locked && !wait) {
            throw new IOException(EclipseAdaptorMsg.formatter.getString("fileManager.cannotLock"));
        }
        if (!locked) {
            do {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            } while (this.lock());
        }
        try {
            this.updateTable();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.release();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.release();
            return;
        }
    }

    private class Entry {
        int readId;
        int writeId;

        Entry(int readId, int writeId) {
            this.readId = readId;
            this.writeId = writeId;
        }

        int getReadId() {
            return this.readId;
        }

        int getWriteId() {
            return this.writeId;
        }

        void setReadId(int value) {
            this.readId = value;
        }

        void setWriteId(int value) {
            this.writeId = value;
        }
    }
}

