/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.actions.AbstractListenerActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;

public class TerminateAllAction
extends AbstractListenerActionDelegate {
    protected void doAction(Object element) throws DebugException {
        ILaunchManager lManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = lManager.getLaunches();
        MultiStatus ms = new MultiStatus(DebugPlugin.getUniqueIdentifier(), 5012, ActionMessages.getString("TerminateAllAction.Terminate_all_failed_3"), null);
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (!launch.isTerminated()) {
                try {
                    launch.terminate();
                }
                catch (DebugException de) {
                    ms.merge(de.getStatus());
                }
            }
            ++i;
        }
        if (!ms.isOK()) {
            throw new DebugException((IStatus)ms);
        }
    }

    protected boolean isRunInBackground() {
        return true;
    }

    protected void update(IAction action, ISelection selection) {
        ILaunchManager lManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = lManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (!launch.isTerminated()) {
                action.setEnabled(true);
                return;
            }
            ++i;
        }
        action.setEnabled(false);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
    }

    protected void doHandleDebugEvent(DebugEvent event) {
        switch (event.getKind()) {
            case 8: {
                this.update(this.getAction(), null);
                break;
            }
            case 4: {
                this.update(this.getAction(), null);
            }
        }
    }
}

