/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.DefaultSourceContainer;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.sourcelookup.AddContainerAction;
import org.eclipse.debug.internal.ui.sourcelookup.DownAction;
import org.eclipse.debug.internal.ui.sourcelookup.EditContainerAction;
import org.eclipse.debug.internal.ui.sourcelookup.RemoveAction;
import org.eclipse.debug.internal.ui.sourcelookup.RestoreDefaultAction;
import org.eclipse.debug.internal.ui.sourcelookup.SourceContainerAction;
import org.eclipse.debug.internal.ui.sourcelookup.SourceContainerViewer;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.debug.internal.ui.sourcelookup.UpAction;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.sourcelookup.WorkingSetSourceContainer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;

public class SourceLookupPanel
extends AbstractLaunchConfigurationTab
implements IPropertyChangeListener {
    protected ILaunchConfiguration fConfig;
    protected SourceContainerViewer fPathViewer;
    protected Button fDuplicatesButton;
    protected List fActions = new ArrayList(6);
    protected ISourceLookupDirector fLocator;
    protected AddContainerAction fAddAction;
    protected EditContainerAction fEditAction;
    protected RestoreDefaultAction fRestoreDefaultAction;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        Label viewerLabel = new Label(comp, 16384);
        viewerLabel.setText(SourceLookupUIMessages.getString("sourceTab.lookupLabel"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        viewerLabel.setLayoutData((Object)gd);
        viewerLabel.setFont(font);
        this.fPathViewer = new SourceContainerViewer(comp, this);
        gd = new GridData(1808);
        this.fPathViewer.getControl().setLayoutData((Object)gd);
        this.fPathViewer.getControl().setFont(font);
        IWorkingSetManager workingSetMgr = DebugUIPlugin.getDefault().getWorkbench().getWorkingSetManager();
        workingSetMgr.addPropertyChangeListener((IPropertyChangeListener)this);
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.createVerticalSpacer(comp, 2);
        this.fDuplicatesButton = new Button(comp, 32);
        this.fDuplicatesButton.setText(SourceLookupUIMessages.getString("sourceTab.searchDuplicateLabel"));
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fDuplicatesButton.setLayoutData((Object)gd);
        this.fDuplicatesButton.setFont(font);
        this.fDuplicatesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SourceLookupPanel.this.setDirty(true);
                SourceLookupPanel.this.updateLaunchConfigurationDialog();
            }
        });
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        this.fAddAction = new AddContainerAction();
        Button button = this.createPushButton(pathButtonComp, this.fAddAction.getText(), fontMetrics);
        this.fAddAction.setButton(button);
        this.addAction(this.fAddAction);
        this.fEditAction = new EditContainerAction();
        button = this.createPushButton(pathButtonComp, this.fEditAction.getText(), fontMetrics);
        this.fEditAction.setButton(button);
        this.addAction(this.fEditAction);
        SourceContainerAction action = new RemoveAction();
        button = this.createPushButton(pathButtonComp, action.getText(), fontMetrics);
        action.setButton(button);
        this.addAction(action);
        action = new UpAction();
        button = this.createPushButton(pathButtonComp, action.getText(), fontMetrics);
        action.setButton(button);
        this.addAction(action);
        action = new DownAction();
        button = this.createPushButton(pathButtonComp, action.getText(), fontMetrics);
        action.setButton(button);
        this.addAction(action);
        this.fRestoreDefaultAction = new RestoreDefaultAction();
        button = this.createPushButton(pathButtonComp, this.fRestoreDefaultAction.getText(), fontMetrics);
        this.fRestoreDefaultAction.setButton(button);
        this.addAction(this.fRestoreDefaultAction);
        this.retargetActions(this.fPathViewer);
        Dialog.applyDialogFont((Control)comp);
        this.setControl((Control)comp);
    }

    protected Button createPushButton(Composite parent, String label, FontMetrics fontMetrics) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        GridData gd = this.getButtonGridData(button, fontMetrics);
        button.setLayoutData((Object)gd);
        return button;
    }

    private GridData getButtonGridData(Button button, FontMetrics fontMetrics) {
        GridData gd = new GridData(770);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        gd.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        return gd;
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    protected void addAction(SourceContainerAction action) {
        this.fActions.add(action);
    }

    protected void retargetActions(SourceContainerViewer viewer) {
        Iterator actions = this.fActions.iterator();
        while (actions.hasNext()) {
            SourceContainerAction action = (SourceContainerAction)((Object)actions.next());
            action.setViewer(viewer);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.fLocator != null) {
            this.fLocator.dispose();
            this.fLocator = null;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        String memento = null;
        String type = null;
        try {
            memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
            type = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (type == null) {
                type = configuration.getType().getSourceLocatorId();
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
            return;
        }
        if (type == null) {
            this.setErrorMessage(SourceLookupUIMessages.getString("sourceLookupPanel.2"));
            return;
        }
        boolean migration = false;
        try {
            IPersistableSourceLocator locator = this.getLaunchManager().newSourceLocator(type);
            if (!(locator instanceof AbstractSourceLookupDirector)) {
                memento = null;
                type = configuration.getType().getSourceLocatorId();
                if (type == null) {
                    this.setErrorMessage(SourceLookupUIMessages.getString("sourceLookupPanel.2"));
                    return;
                }
                locator = this.getLaunchManager().newSourceLocator(type);
                if (!(locator instanceof AbstractSourceLookupDirector)) {
                    this.setErrorMessage(SourceLookupUIMessages.getString("sourceLookupPanel.2"));
                    return;
                }
                migration = true;
            }
            this.fLocator = (AbstractSourceLookupDirector)locator;
            if (memento == null) {
                this.fLocator.initializeDefaults(configuration);
            } else {
                this.fLocator.initializeFromMemento(memento, configuration);
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
            return;
        }
        this.initializeFrom(this.fLocator);
        if (migration && configuration.isWorkingCopy()) {
            this.setDirty(true);
            this.performApply((ILaunchConfigurationWorkingCopy)configuration);
        }
    }

    public void initializeFrom(ISourceLookupDirector locator) {
        if (this.fConfig == null) {
            this.fConfig = locator.getLaunchConfiguration();
        }
        this.fPathViewer.setEntries(locator.getSourceContainers());
        this.fDuplicatesButton.setSelection(locator.isFindDuplicates());
        this.fLocator = locator;
        this.fAddAction.setSourceLookupDirector(locator);
        this.fEditAction.setSourceLookupDirector(locator);
        this.fRestoreDefaultAction.setSourceLookupDirector(locator);
        this.setDirty(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isDirty()) {
            if (this.fLocator == null) {
                configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
                return;
            }
            ILaunchConfigurationWorkingCopy workingCopy = null;
            if (configuration == null) {
                try {
                    workingCopy = this.fLocator.getLaunchConfiguration().getWorkingCopy();
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                    this.setErrorMessage(SourceLookupUIMessages.getString("sourceLookupPanel.1"));
                    return;
                }
            } else {
                workingCopy = configuration;
            }
            if (workingCopy == null) {
                DebugUIPlugin.logErrorMessage(SourceLookupUIMessages.getString("sourceLookupPanel.1"));
                return;
            }
            this.fLocator.setSourceContainers(this.fPathViewer.getEntries());
            this.fLocator.setFindDuplicates(this.fDuplicatesButton.getSelection());
            try {
                if (this.isDefault((ILaunchConfiguration)workingCopy)) {
                    workingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                    workingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
                } else {
                    workingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, this.fLocator.getMemento());
                    workingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, this.fLocator.getId());
                }
                if (configuration == null) {
                    workingCopy.doSave();
                }
                this.setDirty(false);
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
                this.setErrorMessage(SourceLookupUIMessages.getString("sourceLookupPanel.1"));
            }
        }
    }

    protected boolean isDefault(ILaunchConfiguration configuration) {
        ISourceContainer[] current = this.getEntries();
        return current.length == 1 && current[0] instanceof DefaultSourceContainer;
    }

    public ISourceContainer[] getEntries() {
        return this.fPathViewer.getEntries();
    }

    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
    }

    public String getName() {
        return SourceLookupUIMessages.getString("sourceTab.tabTitle");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    protected void updateLaunchConfigurationDialog() {
        if (this.getLaunchConfigurationDialog() != null) {
            super.updateLaunchConfigurationDialog();
        }
    }

    private void validateWorkingSetSourceContainers(IWorkingSet affectedWorkingSet) {
        List sourceContainers = (List)this.fPathViewer.getInput();
        if (sourceContainers != null) {
            int i = 0;
            while (i < sourceContainers.size()) {
                WorkingSetSourceContainer wsSrcContainer;
                if (sourceContainers.get(i) instanceof WorkingSetSourceContainer && (wsSrcContainer = (WorkingSetSourceContainer)((Object)sourceContainers.get(i))).getName().equals(affectedWorkingSet.getName())) {
                    sourceContainers.remove(i);
                }
                ++i;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("workingSetRemove")) {
            this.validateWorkingSetSourceContainers((IWorkingSet)event.getOldValue());
        }
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.initializeFrom((ILaunchConfiguration)workingCopy);
    }

    public ISourceLookupDirector getDirector() {
        return this.fLocator;
    }

    public void dispose() {
        super.dispose();
        IWorkingSetManager workingSetMgr = DebugUIPlugin.getDefault().getWorkbench().getWorkingSetManager();
        workingSetMgr.removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

