/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup.browsers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.ArchiveSourceContainer;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.debug.internal.ui.sourcelookup.browsers.ArchiveFilter;
import org.eclipse.debug.ui.sourcelookup.AbstractSourceContainerBrowser;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class ArchiveSourceContainerBrowser
extends AbstractSourceContainerBrowser {
    private ISelectionStatusValidator validator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            if (selection.length == 0) {
                return new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, "", null);
            }
            int i = 0;
            while (i < selection.length) {
                if (!(selection[i] instanceof IFile)) {
                    return new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, "", null);
                }
                ++i;
            }
            return new Status(0, DebugUIPlugin.getUniqueIdentifier(), 0, "", null);
        }
    };

    protected List getSelectedJars(ISourceLookupDirector director) {
        ISourceContainer[] containers = director.getSourceContainers();
        ArrayList<ISourceContainer> jars = new ArrayList<ISourceContainer>();
        int i = 0;
        while (i < containers.length) {
            ISourceContainer container = containers[i];
            if (container.getType().getId().equals(ArchiveSourceContainer.TYPE_ID)) {
                jars.add(container);
            }
            ++i;
        }
        return jars;
    }

    public ISourceContainer[] addSourceContainers(Shell shell, ISourceLookupDirector director) {
        ArchiveFilter filter = new ArchiveFilter(this.getSelectedJars(director));
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator(this.validator);
        dialog.setTitle(SourceLookupUIMessages.getString("ArchiveSourceContainerBrowser.3"));
        dialog.setMessage(SourceLookupUIMessages.getString("ArchiveSourceContainerBrowser.4"));
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            ISourceContainer[] containers = new ISourceContainer[result.length];
            int i = 0;
            while (i < containers.length) {
                containers[i] = new ArchiveSourceContainer((IFile)result[i], true);
                ++i;
            }
            return containers;
        }
        return new ISourceContainer[0];
    }
}

