/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractDebugEventHandler
implements IDebugEventSetListener {
    private AbstractDebugView fView;
    private List fEventSetQueue = new ArrayList();
    private List fDataQueue = new ArrayList();
    private EventProcessingJob fUpdateJob = new EventProcessingJob();
    protected static final DebugEvent[] EMPTY_EVENT_SET = new DebugEvent[0];
    private Object NULL = new Object();

    public AbstractDebugEventHandler(AbstractDebugView view) {
        this.setView(view);
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.addDebugEventListener((IDebugEventSetListener)this);
    }

    protected IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDebugEvents(DebugEvent[] events) {
        if (!this.isAvailable()) {
            return;
        }
        if ((events = this.filterEvents(events)).length == 0) {
            return;
        }
        if ((events = this.doPreprocessEvents(events)).length == 0) {
            return;
        }
        List list = this.fEventSetQueue;
        synchronized (list) {
            this.fEventSetQueue.add(events);
            List list2 = this.fDataQueue;
            synchronized (list2) {
                if (this.fDataQueue.size() < this.fEventSetQueue.size()) {
                    this.fDataQueue.add(this.NULL);
                }
            }
        }
        this.fUpdateJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueData(Object data) {
        List list = this.fDataQueue;
        synchronized (list) {
            this.fDataQueue.add(data);
        }
    }

    protected DebugEvent[] doPreprocessEvents(DebugEvent[] events) {
        return events;
    }

    protected DebugEvent[] filterEvents(DebugEvent[] events) {
        return events;
    }

    protected void updateForDebugEvents(DebugEvent[] events, Object data) {
    }

    protected abstract void doHandleDebugEvents(DebugEvent[] var1, Object var2);

    protected void insert(Object element) {
        Object parent;
        if (this.isAvailable() && (parent = ((ITreeContentProvider)this.getTreeViewer().getContentProvider()).getParent(element)) != null) {
            this.getView().showViewer();
            this.getTreeViewer().add(parent, element);
        }
    }

    protected void remove(Object element) {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getTreeViewer().remove(element);
        }
    }

    protected void labelChanged(Object element) {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getTreeViewer().update(element, new String[]{"org.eclipse.jface.text"});
        }
    }

    protected void refresh(Object element) {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getTreeViewer().refresh(element);
        }
    }

    public void refresh() {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getTreeViewer().refresh();
        }
    }

    protected void selectAndReveal(Object element) {
        if (this.isAvailable()) {
            this.getViewer().setSelection((ISelection)new StructuredSelection(element), true);
        }
    }

    public void dispose() {
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.removeDebugEventListener((IDebugEventSetListener)this);
        this.fEventSetQueue.clear();
    }

    protected AbstractDebugView getView() {
        return this.fView;
    }

    private void setView(AbstractDebugView view) {
        this.fView = view;
    }

    protected Viewer getViewer() {
        return this.getView().getViewer();
    }

    protected TreeViewer getTreeViewer() {
        if (this.getViewer() instanceof TreeViewer) {
            return (TreeViewer)this.getViewer();
        }
        return null;
    }

    protected boolean isAvailable() {
        return this.getView().isAvailable();
    }

    protected boolean isViewVisible() {
        return this.getView().isVisible();
    }

    protected void viewBecomesVisible() {
        this.refresh();
    }

    protected void viewBecomesHidden() {
    }

    private class EventProcessingJob
    extends UIJob {
        public EventProcessingJob() {
            super(DebugUIViewsMessages.getString("AbstractDebugEventHandler.0"));
            this.setSystem(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            boolean more = true;
            int count = 0;
            while (more && count < 50) {
                DebugEvent[] eventSet = null;
                Object data = null;
                List list = AbstractDebugEventHandler.this.fEventSetQueue;
                synchronized (list) {
                    if (AbstractDebugEventHandler.this.fEventSetQueue.isEmpty()) {
                        return Status.OK_STATUS;
                    }
                    eventSet = (DebugEvent[])AbstractDebugEventHandler.this.fEventSetQueue.remove(0);
                    more = !AbstractDebugEventHandler.this.fEventSetQueue.isEmpty();
                }
                list = AbstractDebugEventHandler.this.fDataQueue;
                synchronized (list) {
                    data = AbstractDebugEventHandler.this.fDataQueue.remove(0);
                    if (data == AbstractDebugEventHandler.this.NULL) {
                        data = null;
                    }
                }
                if (AbstractDebugEventHandler.this.isAvailable()) {
                    if (AbstractDebugEventHandler.this.isViewVisible()) {
                        AbstractDebugEventHandler.this.doHandleDebugEvents(eventSet, data);
                    }
                    AbstractDebugEventHandler.this.updateForDebugEvents(eventSet, data);
                }
                ++count;
            }
            if (more) {
                this.schedule(50L);
            }
            return Status.OK_STATUS;
        }
    }
}

