/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.ui.IBreakpointContainer;
import org.eclipse.debug.ui.IBreakpointContainerFactory;
import org.eclipse.debug.ui.IBreakpointContainerFactoryDelegate;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BreakpointFileContainerFactoryDelegate
implements IBreakpointContainerFactoryDelegate {
    private ILabelProvider fImageProvider = new WorkbenchLabelProvider();

    public IBreakpointContainer[] createContainers(IBreakpoint[] breakpoints, IBreakpointContainerFactory factory) {
        IResource resource;
        HashMap<IResource, ArrayList<IBreakpoint>> map = new HashMap<IResource, ArrayList<IBreakpoint>>();
        ArrayList<Object> other = new ArrayList<Object>();
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            IMarker marker = breakpoint.getMarker();
            if (marker != null && (resource = marker.getResource()) != null) {
                ArrayList<IBreakpoint> list = (ArrayList<IBreakpoint>)map.get(resource);
                if (list == null) {
                    list = new ArrayList<IBreakpoint>();
                    map.put(resource, list);
                }
                list.add(breakpoint);
            } else {
                other.add(breakpoint);
            }
            ++i;
        }
        ArrayList<BreakpointContainer> containers = new ArrayList<BreakpointContainer>(map.size());
        Set resources = map.keySet();
        Iterator breakpointIter = resources.iterator();
        while (breakpointIter.hasNext()) {
            String parentPath;
            resource = (IResource)breakpointIter.next();
            List breakpointsForFile = (List)map.get(resource);
            StringBuffer name = new StringBuffer(resource.getName());
            if (name.length() < 1) {
                Iterator iter = breakpointsForFile.iterator();
                while (iter.hasNext()) {
                    other.add(iter.next());
                }
                continue;
            }
            IContainer parent = resource.getParent();
            if (parent != null && (parentPath = parent.getFullPath().toString().substring(1)).length() > 0) {
                name.append(" [");
                name.append(parentPath);
                name.append(']');
            }
            BreakpointContainer container = new BreakpointContainer(breakpointsForFile.toArray(new IBreakpoint[0]), factory, name.toString());
            container.setContainerImage(this.fImageProvider.getImage((Object)resource));
            containers.add(container);
        }
        if (other.size() > 0) {
            BreakpointContainer container = new BreakpointContainer(other.toArray(new IBreakpoint[0]), factory, DebugUIViewsMessages.getString("BreakpointFileContainerFactory.0"));
            Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            container.setContainerImage(image);
            containers.add(container);
        }
        return containers.toArray(new IBreakpointContainer[containers.size()]);
    }

    public void dispose() {
        this.fImageProvider.dispose();
    }
}

