/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.ui.IBreakpointContainer;
import org.eclipse.debug.ui.IBreakpointContainerFactory;
import org.eclipse.debug.ui.IBreakpointContainerFactoryDelegate;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BreakpointProjectContainerFactoryDelegate
implements IBreakpointContainerFactoryDelegate {
    private ILabelProvider fImageProvider = new WorkbenchLabelProvider();

    public IBreakpointContainer[] createContainers(IBreakpoint[] breakpoints, IBreakpointContainerFactory factory) {
        ArrayList<IBreakpoint> list;
        IProject project;
        HashMap<IProject, ArrayList<IBreakpoint>> map = new HashMap<IProject, ArrayList<IBreakpoint>>();
        ArrayList<IBreakpoint> other = new ArrayList<IBreakpoint>();
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            IMarker marker = breakpoint.getMarker();
            if (marker != null && (project = marker.getResource().getProject()) != null) {
                list = (ArrayList<IBreakpoint>)map.get(project);
                if (list == null) {
                    list = new ArrayList<IBreakpoint>();
                    map.put(project, list);
                }
                list.add(breakpoint);
            } else {
                other.add(breakpoint);
            }
            ++i;
        }
        ArrayList<BreakpointContainer> containers = new ArrayList<BreakpointContainer>(map.size());
        Set projects = map.keySet();
        Iterator iter = projects.iterator();
        while (iter.hasNext()) {
            project = (IProject)iter.next();
            list = (List)map.get(project);
            BreakpointContainer container = new BreakpointContainer(list.toArray(new IBreakpoint[0]), factory, project.getName());
            container.setContainerImage(this.fImageProvider.getImage((Object)project));
            containers.add(container);
        }
        if (other.size() > 0) {
            BreakpointContainer container = new BreakpointContainer(other.toArray(new IBreakpoint[0]), factory, DebugUIViewsMessages.getString("BreakpointProjectContainerFactory.0"));
            Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
            container.setContainerImage(image);
            containers.add(container);
        }
        return containers.toArray(new IBreakpointContainer[containers.size()]);
    }

    public void dispose() {
        this.fImageProvider.dispose();
    }
}

