/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.expression;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.AbstractHandler;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.commands.Priority;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;

public abstract class PopupInformationControl
implements IInformationControl,
IInformationControlExtension {
    private static final String HEIGHT_STRING = "_DEBUGPOPUP_HEIGHT";
    private static final String WIDTH_STRING = "_DEBUGPOPUP_WIDTH";
    protected Shell shell;
    private int maxWidth = 300;
    private int maxHeight = 300;
    private HandlerSubmission submission;
    private IHandler closeHandler = new CloseHandler();
    private String commandId = null;
    private Control control = null;

    public PopupInformationControl(Shell parent, String labelText, String commandId) {
        List keyBindings;
        this.commandId = commandId;
        this.shell = new Shell(parent, 16);
        Display display = this.shell.getDisplay();
        this.shell.setForeground(display.getSystemColor(28));
        this.shell.setBackground(display.getSystemColor(29));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.shell.setLayout((Layout)layout);
        this.shell.setLayoutData((Object)new GridData(1808));
        this.control = this.createControl((Composite)this.shell);
        this.register();
        ICommandManager commandManager = PlatformUI.getWorkbench().getCommandSupport().getCommandManager();
        ICommand command = null;
        if (commandId != null) {
            command = commandManager.getCommand(commandId);
        }
        Label separator = new Label((Composite)this.shell, 259);
        separator.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)this.shell, 131104);
        label.setText(labelText);
        label.setForeground(display.getSystemColor(28));
        label.setBackground(display.getSystemColor(29));
        label.setEnabled(false);
        label.setLayoutData((Object)new GridData(896));
        if (command != null && (keyBindings = command.getKeySequenceBindings()) != null && keyBindings.size() > 0) {
            IKeySequenceBinding keySequenceBinding = (IKeySequenceBinding)keyBindings.get(0);
            label.setText(MessageFormat.format(DebugUIMessages.getString("PopupInformationControl.1"), keySequenceBinding.getKeySequence().format(), labelText));
            label.getParent().layout();
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        this.shell.addDisposeListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.shell.addFocusListener(listener);
    }

    public Point computeSizeHint() {
        Point persistedSize = this.getInitialSize();
        if (persistedSize != null) {
            return persistedSize;
        }
        Point computedSize = this.shell.computeSize(-1, -1, true);
        if (this.maxWidth > 0 && computedSize.x > this.maxWidth) {
            computedSize.x = this.maxWidth;
        }
        if (this.maxHeight > 0 && computedSize.y > this.maxHeight) {
            computedSize.y = this.maxHeight;
        }
        return computedSize;
    }

    public void dispose() {
        this.deregister();
        this.persistSize();
        this.shell = null;
    }

    private void deregister() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchContextSupport contextSupport = workbench.getContextSupport();
        IWorkbenchCommandSupport commandSupport = workbench.getCommandSupport();
        commandSupport.removeHandlerSubmission(this.submission);
        contextSupport.unregisterShell(this.shell);
    }

    private void register() {
        if (this.closeHandler != null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchContextSupport contextSupport = workbench.getContextSupport();
            IWorkbenchCommandSupport commandSupport = workbench.getCommandSupport();
            this.submission = new HandlerSubmission(null, this.shell, null, this.commandId, this.closeHandler, Priority.MEDIUM);
            commandSupport.addHandlerSubmission(this.submission);
            contextSupport.registerShell(this.shell, 0);
        }
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.shell.removeDisposeListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.shell.removeFocusListener(listener);
    }

    public void setBackgroundColor(Color background) {
        this.shell.setBackground(background);
    }

    public void setForegroundColor(Color foreground) {
        this.shell.setForeground(foreground);
    }

    public void setLocation(Point location) {
        Rectangle displayBounds = this.control.getDisplay().getClientArea();
        location.x = location.x < 0 ? displayBounds.x + 25 : location.x;
        location.y = location.y < 0 ? displayBounds.y + 25 : location.y;
        Point shellSize = this.shell.getSize();
        boolean shellSizeChanged = false;
        if (shellSize.x + location.x > displayBounds.width) {
            shellSize.x = displayBounds.width - location.x;
            shellSizeChanged = true;
        }
        if (shellSize.y + location.y > displayBounds.height) {
            shellSize.y = displayBounds.height - location.y;
            shellSizeChanged = true;
        }
        if (shellSizeChanged) {
            this.shell.setSize(shellSize);
        }
        this.shell.setLocation(location);
    }

    public void setSize(int width, int height) {
        this.shell.setSize(width, height);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public void setVisible(boolean visible) {
        this.shell.setVisible(visible);
        if (!visible) {
            this.deregister();
            this.shell.dispose();
        }
    }

    protected abstract Control createControl(Composite var1);

    protected Point getInitialSize() {
        Point point = null;
        try {
            IDialogSettings settings = this.getDialogSettings();
            if (settings != null) {
                String key = this.getClass().getName();
                int height = settings.getInt(String.valueOf(key) + HEIGHT_STRING);
                int width = settings.getInt(String.valueOf(key) + WIDTH_STRING);
                point = new Point(width, height);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return point;
    }

    protected IDialogSettings getDialogSettings() {
        return DebugUIPlugin.getDefault().getDialogSettings();
    }

    protected void persistSize() {
        if (this.shell == null) {
            return;
        }
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String key = this.getClass().getName();
            Point size = this.shell.getSize();
            settings.put(String.valueOf(key) + WIDTH_STRING, size.x);
            settings.put(String.valueOf(key) + HEIGHT_STRING, size.y);
        }
    }

    protected abstract void performCommand();

    protected Shell getShell() {
        return this.shell;
    }

    public boolean isFocusControl() {
        return this.control.isFocusControl();
    }

    public void setFocus() {
        this.control.setFocus();
    }

    private class CloseHandler
    extends AbstractHandler {
        CloseHandler() {
        }

        public Object execute(Map parameter) throws ExecutionException {
            PopupInformationControl.this.performCommand();
            if (PopupInformationControl.this.shell != null) {
                PopupInformationControl.this.shell.dispose();
            }
            return null;
        }
    }
}

