/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.preferences.DebugWorkInProgressPreferencePage;
import org.eclipse.debug.internal.ui.views.RemoteTreeContentManager;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewer;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;

public class DebugViewContentProvider
extends BaseWorkbenchContentProvider
implements IPropertyChangeListener {
    private DeferredTreeContentManager fManager;
    private boolean fUseDeferredContent = false;
    static /* synthetic */ Class class$0;

    public DebugViewContentProvider(LaunchViewer tree, IWorkbenchPartSite site) {
        this.fManager = new RemoteTreeContentManager((ITreeContentProvider)this, tree, site);
        IPreferenceStore preferenceStore = DebugUITools.getPreferenceStore();
        this.fUseDeferredContent = preferenceStore.getBoolean(DebugWorkInProgressPreferencePage.WIP_PREF_USE_BACKGROUND_CONTENT);
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = null;
        if (this.fUseDeferredContent) {
            children = this.fManager.getChildren(parentElement);
        }
        if (children == null) {
            children = super.getChildren(parentElement);
        }
        return children;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IStackFrame) {
            return false;
        }
        if (element instanceof IDebugTarget) {
            try {
                return ((IDebugTarget)element).hasThreads();
            }
            catch (DebugException debugException) {
                return false;
            }
        }
        if (element instanceof IThread) {
            try {
                return ((IThread)element).hasStackFrames();
            }
            catch (DebugException debugException) {
                return false;
            }
        }
        if (element instanceof IProcess) {
            return false;
        }
        if (element instanceof ILaunch) {
            return ((ILaunch)element).hasChildren();
        }
        if (element instanceof ILaunchManager) {
            return ((ILaunchManager)element).getLaunches().length > 0;
        }
        if (element instanceof IAdaptable) {
            IDeferredWorkbenchAdapter adapter;
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.progress.IDeferredWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IDeferredWorkbenchAdapter)adaptable.getAdapter((Class)clazz)) != null) {
                return adapter.isContainer();
            }
        }
        return super.hasChildren(element);
    }

    public void dispose() {
        this.fManager.cancel((Object)DebugPlugin.getDefault().getLaunchManager());
        DebugUITools.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(DebugWorkInProgressPreferencePage.WIP_PREF_USE_BACKGROUND_CONTENT)) {
            this.fUseDeferredContent = DebugUITools.getPreferenceStore().getBoolean(DebugWorkInProgressPreferencePage.WIP_PREF_USE_BACKGROUND_CONTENT);
        }
    }
}

