/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewer;

public class LaunchViewEventHandler
extends AbstractDebugEventHandler
implements ILaunchesListener2 {
    private ThreadTimer fThreadTimer = new ThreadTimer();
    private IStackFrame fLastStackFrame = null;

    public LaunchViewEventHandler(LaunchView view) {
        super(view);
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    protected DebugEvent[] filterEvents(DebugEvent[] events) {
        if (events.length > 0) {
            DebugEvent event = events[0];
            Object source = event.getSource();
            ILaunch launch = null;
            if (source instanceof IDebugElement) {
                launch = ((IDebugElement)source).getLaunch();
            } else if (source instanceof IProcess) {
                launch = ((IProcess)source).getLaunch();
            }
            if (launch != null && DebugPlugin.getDefault().getLaunchManager().isRegistered(launch)) {
                return events;
            }
            return AbstractDebugEventHandler.EMPTY_EVENT_SET;
        }
        return events;
    }

    protected void doHandleDebugEvents(DebugEvent[] events, Object data) {
        this.fThreadTimer.handleDebugEvents(events);
        Object suspendee = null;
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            Object source = event.getSource();
            switch (event.getKind()) {
                case 4: {
                    this.insert(source);
                    if (!(source instanceof IDebugTarget)) break;
                    this.getLaunchView().autoExpand(source, true);
                    break;
                }
                case 8: {
                    if (source instanceof IThread) {
                        this.clearSourceSelection(source);
                        this.fThreadTimer.getTimedOutThreads().remove(source);
                        this.remove(source);
                        break;
                    }
                    ILaunch parent = null;
                    if (source instanceof IDebugTarget) {
                        this.clearSourceSelection(source);
                        parent = ((IDebugTarget)source).getLaunch();
                    } else if (source instanceof IProcess) {
                        parent = ((IProcess)source).getLaunch();
                    }
                    if (parent == null) break;
                    this.refresh(parent);
                    break;
                }
                case 1: {
                    this.doHandleResumeEvent(event, source, data);
                    break;
                }
                case 2: {
                    if (suspendee != null && suspendee.equals(source)) break;
                    this.doHandleSuspendEvent(source, event, data);
                    suspendee = source;
                    break;
                }
                case 16: {
                    IStackFrame lastFrame = this.getLaunchView().getStackFrame();
                    if (source instanceof IStackFrame && source.equals(lastFrame)) {
                        this.getLaunchView().setStackFrame(null);
                        this.getLaunchView().autoExpand(lastFrame, true);
                    }
                    if (event.getDetail() == 256) {
                        this.labelChanged(source);
                    } else {
                        this.refresh(source);
                    }
                    if (lastFrame == null || !(source instanceof IThread) || !lastFrame.getThread().equals(source)) break;
                    this.getLaunchView().autoExpand(lastFrame, true);
                }
            }
            ++i;
        }
    }

    protected void doHandleResumeEvent(DebugEvent event, Object source, Object data) {
        if (!event.isEvaluation()) {
            this.clearSourceSelection(source);
        }
        if (event.isEvaluation() || event.isStepStart()) {
            IThread thread = this.getThread(source);
            if (thread != null) {
                this.fThreadTimer.startTimer(thread);
            }
            return;
        }
        this.refresh(source);
        if (source instanceof IThread) {
            if (data instanceof IStackFrame) {
                this.selectAndReveal(data);
                return;
            }
            this.selectAndReveal(source);
            return;
        }
    }

    protected void updateRunningThread(IThread thread) {
        this.labelChanged(thread);
        this.getLaunchViewer().updateStackFrameImages(thread);
        this.clearSourceSelection(thread);
    }

    protected void doHandleSuspendEvent(Object element, DebugEvent event, Object data) {
        IThread thread = this.getThread(element);
        if (thread != null) {
            this.fThreadTimer.stopTimer(thread);
        }
        boolean wasTimedOut = this.fThreadTimer.getTimedOutThreads().remove(thread);
        if (event.isEvaluation() && (event.getDetail() & 0x80) != 0 && thread != null && !wasTimedOut) {
            return;
        }
        if (element instanceof IThread) {
            this.doHandleSuspendThreadEvent((IThread)element, event, wasTimedOut, data);
            return;
        }
        this.refresh(element);
    }

    protected void doHandleSuspendThreadEvent(IThread thread, DebugEvent event, boolean wasTimedOut, Object data) {
        if (!thread.isSuspended() || !this.isAvailable()) {
            return;
        }
        boolean evaluationEvent = event.isEvaluation();
        IStackFrame frame = null;
        if (data instanceof IStackFrame) {
            frame = (IStackFrame)data;
        }
        if (frame != null && frame.equals(this.fLastStackFrame)) {
            if (wasTimedOut) {
                this.getLaunchViewer().updateStackFrameImages(thread);
            }
            this.getLaunchViewer().update(new Object[]{thread, frame}, null);
            if (!evaluationEvent) {
                this.getLaunchViewer().deferExpansion(thread);
                this.getLaunchViewer().setDeferredSelection(frame);
            } else if (wasTimedOut) {
                this.getLaunchView().showEditorForCurrentSelection();
            }
            return;
        }
        if (frame != null) {
            this.fLastStackFrame = frame;
            this.getLaunchView().autoExpand(thread, false);
            if (this.fLastStackFrame != null) {
                this.getLaunchView().autoExpand(this.fLastStackFrame, !evaluationEvent);
            }
        }
    }

    protected void updateForDebugEvents(DebugEvent[] events, Object data) {
        super.updateForDebugEvents(events, data);
        if (this.isViewVisible()) {
            return;
        }
        this.doHandleDebugEvents(events, data);
    }

    public void dispose() {
        super.dispose();
        this.fThreadTimer.stop();
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getLaunchManager().removeLaunchListener((ILaunchesListener)this);
    }

    private void clearSourceSelection(Object source) {
        if (this.getViewer() != null) {
            this.getLaunchView().clearSourceSelection(source);
        }
    }

    protected LaunchViewer getLaunchViewer() {
        return (LaunchViewer)this.getViewer();
    }

    protected LaunchView getLaunchView() {
        return (LaunchView)this.getView();
    }

    private IThread getThread(Object element) {
        IThread thread = null;
        if (element instanceof IThread) {
            thread = (IThread)element;
        } else if (element instanceof IStackFrame) {
            thread = ((IStackFrame)element).getThread();
        }
        return thread;
    }

    public void launchesAdded(final ILaunch[] launches) {
        Runnable r = new Runnable(){

            public void run() {
                if (LaunchViewEventHandler.this.isAvailable()) {
                    if (launches.length == 1) {
                        LaunchViewEventHandler.this.insert(launches[0]);
                    } else {
                        LaunchViewEventHandler.this.refresh();
                    }
                    int i = 0;
                    while (i < launches.length) {
                        if (launches[i].hasChildren()) {
                            LaunchViewEventHandler.this.getLaunchView().autoExpand(launches[i], false);
                        }
                        ++i;
                    }
                }
            }
        };
        this.getView().syncExec(r);
    }

    public void launchesChanged(final ILaunch[] launches) {
        Runnable r = new Runnable(){

            public void run() {
                if (LaunchViewEventHandler.this.isAvailable()) {
                    if (launches.length == 1) {
                        LaunchViewEventHandler.this.refresh(launches[0]);
                    } else {
                        LaunchViewEventHandler.this.refresh();
                    }
                    int i = 0;
                    while (i < launches.length) {
                        if (launches[i].hasChildren()) {
                            LaunchViewEventHandler.this.getLaunchView().autoExpand(launches[i], false);
                        }
                        ++i;
                    }
                }
            }
        };
        this.getView().syncExec(r);
    }

    public void launchesRemoved(final ILaunch[] launches) {
        Runnable r = new Runnable(){

            public void run() {
                if (LaunchViewEventHandler.this.isAvailable()) {
                    if (launches.length == 1) {
                        LaunchViewEventHandler.this.remove(launches[0]);
                    } else {
                        LaunchViewEventHandler.this.refresh();
                    }
                    LaunchViewEventHandler.this.getLaunchView().cleanupLaunches(launches);
                    ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
                    IDebugTarget[] targets = lm.getDebugTargets();
                    if (targets.length > 0) {
                        IDebugTarget target = targets[targets.length - 1];
                        try {
                            IThread[] threads = target.getThreads();
                            int i = 0;
                            while (i < threads.length) {
                                if (threads[i].isSuspended()) {
                                    IStackFrame topStackFrame = threads[i].getTopStackFrame();
                                    if (topStackFrame != null) {
                                        LaunchViewEventHandler.this.getLaunchView().autoExpand(topStackFrame, true);
                                    }
                                    return;
                                }
                                ++i;
                            }
                        }
                        catch (DebugException de) {
                            DebugUIPlugin.log(de);
                        }
                        LaunchViewEventHandler.this.getLaunchView().autoExpand(target.getLaunch(), true);
                    }
                }
            }
        };
        this.getView().asyncExec(r);
    }

    public void launchesTerminated(final ILaunch[] launches) {
        if (this.fLastStackFrame != null) {
            ILaunch launch = this.fLastStackFrame.getLaunch();
            int i = 0;
            while (i < launches.length) {
                ILaunch terminatedLaunch = launches[i];
                if (terminatedLaunch.equals(launch)) {
                    this.fLastStackFrame = null;
                }
                ++i;
            }
        }
        Runnable r = new Runnable(){

            public void run() {
                LaunchViewEventHandler.this.getLaunchView().cleanupLaunches(launches);
            }
        };
        this.getView().asyncExec(r);
    }

    protected DebugEvent[] doPreprocessEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            Object source = event.getSource();
            block2 : switch (event.getKind()) {
                case 2: {
                    if (!(source instanceof IThread)) break;
                    IThread thread = (IThread)source;
                    try {
                        IStackFrame frame = thread.getTopStackFrame();
                        this.queueData(frame);
                    }
                    catch (DebugException debugException) {}
                    break;
                }
                case 1: {
                    if (!(source instanceof IThread) || event.getDetail() != 32) break;
                    try {
                        IDebugTarget target = ((IThread)source).getDebugTarget();
                        IThread[] threads = target.getThreads();
                        int j = 0;
                        while (j < threads.length) {
                            IStackFrame frame = threads[j].getTopStackFrame();
                            if (frame != null) {
                                this.queueData(frame);
                                break block2;
                            }
                            ++j;
                        }
                        break;
                    }
                    catch (DebugException debugException) {}
                }
            }
            ++i;
        }
        return events;
    }

    class ThreadTimer {
        private Thread fThread;
        private long TIMEOUT = 500L;
        private long timeEmpty = 0L;
        private long MAX_TIME_EMPTY = 3000L;
        private boolean fStopped = false;
        private Object fLock = new Object();
        HashMap fStopTimes = new HashMap();
        HashSet fTimedOutThreads = new HashSet();

        ThreadTimer() {
        }

        public Set getTimedOutThreads() {
            return this.fTimedOutThreads;
        }

        public void handleDebugEvents(DebugEvent[] events) {
            if (this.fStopped) {
                return;
            }
            int i = 0;
            int numEvents = events.length;
            while (i < numEvents) {
                DebugEvent event = events[i];
                if (event.getKind() == 8 && event.getSource() instanceof IDebugTarget) {
                    ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
                    int j = 0;
                    while (j < launches.length) {
                        IDebugTarget[] targets = launches[j].getDebugTargets();
                        int k = 0;
                        while (k < targets.length) {
                            IDebugTarget target = targets[k];
                            if (target != null && !target.isDisconnected() && !target.isTerminated()) {
                                return;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    this.stop();
                    return;
                }
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startTimer(IThread thread) {
            Object object = this.fLock;
            synchronized (object) {
                this.fStopTimes.put(thread, new Long(System.currentTimeMillis() + this.TIMEOUT));
                if (this.fThread == null) {
                    this.startThread();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.fLock;
            synchronized (object) {
                this.fStopped = true;
                this.fThread = null;
                this.fStopTimes.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopTimer(IThread thread) {
            Object object = this.fLock;
            synchronized (object) {
                this.fStopTimes.remove(thread);
            }
        }

        private void startThread() {
            this.fThread = new Thread(new Runnable(this){
                final /* synthetic */ ThreadTimer this$1;
                {
                    this.this$1 = threadTimer;
                }

                public void run() {
                    ThreadTimer.access$0(this.this$1, false);
                    while (!ThreadTimer.access$1(this.this$1)) {
                        ThreadTimer.access$2(this.this$1);
                    }
                }
            }, "Thread timer");
            this.fThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkTimers() {
            Map.Entry[] entries;
            long timeToWait = this.TIMEOUT;
            Object object = this.fLock;
            synchronized (object) {
                if (this.fStopTimes.size() == 0) {
                    if (this.timeEmpty == 0L) {
                        this.timeEmpty = System.currentTimeMillis();
                    } else if (System.currentTimeMillis() - this.timeEmpty > this.MAX_TIME_EMPTY) {
                        this.stop();
                        return;
                    }
                } else {
                    this.timeEmpty = 0L;
                }
                entries = this.fStopTimes.entrySet().toArray(new Map.Entry[0]);
            }
            long currentTime = System.currentTimeMillis();
            Map.Entry entry = null;
            int i = 0;
            int numEntries = entries.length;
            while (i < numEntries) {
                entry = entries[i];
                Long entryValue = (Long)entry.getValue();
                if (entryValue != null) {
                    long stopTime = entryValue;
                    if (stopTime <= currentTime) {
                        IThread thread = (IThread)entry.getKey();
                        this.fStopTimes.remove(thread);
                        LaunchViewEventHandler.this.getView().asyncExec(new Runnable(this, thread){
                            final /* synthetic */ ThreadTimer this$1;
                            private final /* synthetic */ IThread val$thread;
                            {
                                this.this$1 = threadTimer;
                                this.val$thread = iThread;
                            }

                            public void run() {
                                this.this$1.fTimedOutThreads.add(this.val$thread);
                                ThreadTimer.access$3(this.this$1).updateRunningThread(this.val$thread);
                            }
                        });
                    } else {
                        timeToWait = Math.min(timeToWait, stopTime - currentTime);
                    }
                }
                ++i;
            }
            try {
                Thread.sleep(timeToWait);
            }
            catch (InterruptedException interruptedException) {}
        }

        static /* synthetic */ void access$0(ThreadTimer threadTimer, boolean bl) {
            threadTimer.fStopped = bl;
        }

        static /* synthetic */ boolean access$1(ThreadTimer threadTimer) {
            return threadTimer.fStopped;
        }

        static /* synthetic */ void access$2(ThreadTimer threadTimer) {
            threadTimer.checkTimers();
        }

        static /* synthetic */ LaunchViewEventHandler access$3(ThreadTimer threadTimer) {
            return threadTimer.LaunchViewEventHandler.this;
        }
    }
}

