/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.views.memory.AbstractTextRenderer;

public class ASCIIRenderer
extends AbstractTextRenderer {
    private static final String ASCII_CODE_PAGE = "Cp1252";
    private final int numCharsPerByte = 1;

    public ASCIIRenderer() {
        this.setCodePage(ASCII_CODE_PAGE);
    }

    public int getNumCharPerByte() {
        return 1;
    }

    public byte[] getBytes(String renderingId, BigInteger address, MemoryByte[] currentValues, String data) {
        byte[] bytes = super.getBytes(renderingId, address, currentValues, data);
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] == 1 && currentValues[i].getValue() == 0) {
                bytes[i] = 0;
            }
            ++i;
        }
        return bytes;
    }

    public String getString(String renderingId, BigInteger address, MemoryByte[] data, String paddedStr) {
        MemoryByte[] copy = new MemoryByte[data.length];
        int i = 0;
        while (i < data.length) {
            copy[i] = new AbstractTextRenderer.RendererMemoryByte(this);
            if (data[i].getValue() == 0) {
                copy[i].setValue((byte)1);
            } else {
                copy[i].setValue(data[i].getValue());
            }
            copy[i].setFlags(data[i].getFlags());
            ++i;
        }
        return super.getString(renderingId, address, copy, paddedStr);
    }
}

