/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.AddMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.AddMemoryRenderingDialog;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRendering;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRenderingType;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.IRenderingViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryRenderingManager;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class AddMemoryRenderingAction
extends AddMemoryBlockAction {
    public static final String PREFIX = "AddMemoryRenderingAction.";
    public static final String TITLE = "AddMemoryRenderingAction.title";
    public static final String ADD_RENDERING_FAILED = "AddMemoryRenderingAction.add_rendering_failed";
    public static final String FAILED_TO_ADD_THE_SELECTED_RENDERING = "AddMemoryRenderingAction.failed_to_add_the_selected_rendering";
    static /* synthetic */ Class class$0;

    public AddMemoryRenderingAction(IMemoryViewPane viewPane) {
        super(DebugUIMessages.getString("AddMemoryRenderingAction.Add_renderings"), 1);
        this.setToolTipText(DebugUIMessages.getString("AddMemoryRenderingAction.Add_renderings"));
        WorkbenchHelp.setHelp((IAction)this, (String)(String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".AddRenderingContextAction_context"));
        this.fViewPane = viewPane;
    }

    public void run() {
        Shell shell = DebugUIPlugin.getShell();
        IDebugElement elem = this.getDebugElement(this.fCurrentSelection);
        if (elem != null) {
            IMemoryBlockRetrieval standardMemRetrieval;
            AddMemoryRenderingDialog dialog = new AddMemoryRenderingDialog(shell, this.fViewPane);
            dialog.open();
            Object[] renderings = dialog.getResult();
            IMemoryBlock blk = dialog.getMemoryBlock();
            if (blk == null) {
                return;
            }
            IDebugTarget debugTarget = elem.getDebugTarget();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((standardMemRetrieval = (IMemoryBlockRetrieval)elem.getAdapter((Class)clazz)) == null) {
                standardMemRetrieval = debugTarget;
            }
            if (standardMemRetrieval == null) {
                return;
            }
            int i = 0;
            while (i < renderings.length) {
                if (renderings[i] instanceof IMemoryRenderingType) {
                    String id = ((IMemoryRenderingType)renderings[i]).getRenderingId();
                    try {
                        IMemoryRendering rendering = MemoryRenderingManager.getMemoryRenderingManager().createRendering(blk, id);
                        if (rendering != null && this.fViewPane instanceof IRenderingViewPane) {
                            ((IRenderingViewPane)this.fViewPane).addMemoryRendering(rendering);
                        }
                    }
                    catch (DebugException debugException) {
                        MemoryViewUtil.openError(DebugUIMessages.getString("AddMemoryRenderingAction.Add_rendering_failed"), DebugUIMessages.getString("AddMemoryRenderingAction.Unable_to_add_selected_renderings"), null);
                    }
                }
                ++i;
            }
        }
    }

    private IDebugElement getDebugElement(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        if (selection == null || selection.isEmpty() || ((IStructuredSelection)selection).size() > 1) {
            return null;
        }
        Object elem = ((IStructuredSelection)selection).getFirstElement();
        if (!(elem instanceof IDebugElement)) {
            return null;
        }
        return (IDebugElement)elem;
    }
}

