/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.IMemoryBlockViewSynchronizer;
import org.eclipse.debug.internal.ui.views.memory.ISynchronizedMemoryBlockView;
import org.eclipse.debug.internal.ui.views.memory.ISynchronizerListener;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.SynchronizeInfo;

public class MemoryBlockViewSynchronizer
implements IMemoryBlockViewSynchronizer,
IMemoryBlockListener {
    private Hashtable fSynchronizeInfo = new Hashtable();
    private boolean fEnabled = true;
    private ArrayList fSynchronizerListener;

    public MemoryBlockViewSynchronizer() {
        MemoryViewUtil.getMemoryBlockManager().addListener((IMemoryBlockListener)this);
        this.fSynchronizerListener = new ArrayList();
    }

    public void addView(ISynchronizedMemoryBlockView view, String[] filters) {
        IMemoryBlock key = view.getMemoryBlock();
        if (this.fSynchronizeInfo.get(key) == null) {
            SynchronizeInfo newInfo = new SynchronizeInfo(view.getMemoryBlock());
            this.fSynchronizeInfo.put(key, newInfo);
            newInfo.addSynchronizedView(view, filters);
        } else {
            SynchronizeInfo info = (SynchronizeInfo)this.fSynchronizeInfo.get(key);
            info.addSynchronizedView(view, filters);
        }
    }

    public void removeView(ISynchronizedMemoryBlockView view) {
        IMemoryBlock key = view.getMemoryBlock();
        if (this.fSynchronizeInfo.get(key) == null) {
            return;
        }
        SynchronizeInfo info = (SynchronizeInfo)this.fSynchronizeInfo.get(key);
        info.removeSynchronizedView(view);
    }

    public void setSynchronizedProperty(IMemoryBlock memoryBlock, String propertyId, Object value) {
        Object oldValue;
        SynchronizeInfo info = (SynchronizeInfo)this.fSynchronizeInfo.get(memoryBlock);
        if (info == null) {
            info = new SynchronizeInfo(memoryBlock);
            this.fSynchronizeInfo.put(memoryBlock, info);
        }
        if ((oldValue = info.getProperty(propertyId)) == null) {
            info.setProperty(propertyId, value);
            info.firePropertyChanged(propertyId);
            return;
        }
        if (!oldValue.equals(value)) {
            info.setProperty(propertyId, value);
            info.firePropertyChanged(propertyId);
        }
    }

    public Object getSynchronizedProperty(IMemoryBlock memoryBlock, String propertyId) {
        SynchronizeInfo info = (SynchronizeInfo)this.fSynchronizeInfo.get(memoryBlock);
        if (info != null) {
            Object value = info.getProperty(propertyId);
            return value;
        }
        return null;
    }

    public void memoryBlocksAdded(IMemoryBlock[] memoryBlocks) {
    }

    public void memoryBlocksRemoved(IMemoryBlock[] memoryBlocks) {
        int i = 0;
        while (i < memoryBlocks.length) {
            IMemoryBlock memory = memoryBlocks[i];
            SynchronizeInfo info = (SynchronizeInfo)this.fSynchronizeInfo.get(memory);
            if (info != null) {
                info.delete();
                this.fSynchronizeInfo.remove(memory);
            }
            ++i;
        }
    }

    public void setPropertyFilters(ISynchronizedMemoryBlockView view, String[] filters) {
        IMemoryBlock blk = view.getMemoryBlock();
        SynchronizeInfo info = (SynchronizeInfo)this.fSynchronizeInfo.get(blk);
        if (info != null) {
            info.setPropertyFilters(view, filters);
        }
    }

    public void shutdown() {
        if (this.fSynchronizeInfo != null) {
            Enumeration enumeration = this.fSynchronizeInfo.elements();
            while (enumeration.hasMoreElements()) {
                SynchronizeInfo info = (SynchronizeInfo)enumeration.nextElement();
                info.delete();
            }
            this.fSynchronizeInfo.clear();
            this.fSynchronizeInfo = null;
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.fEnabled) {
            this.fEnabled = enabled;
            EnablementNotifier notifier = new EnablementNotifier(enabled);
            Platform.run((ISafeRunnable)notifier);
        }
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void addSynchronizerListener(ISynchronizerListener listener) {
        if (!this.fSynchronizerListener.contains(listener)) {
            this.fSynchronizerListener.add(listener);
        }
    }

    public void removeSynchronizerListener(ISynchronizerListener listener) {
        if (this.fSynchronizerListener.contains(listener)) {
            this.fSynchronizerListener.remove(listener);
        }
    }

    class EnablementNotifier
    implements ISafeRunnable {
        private boolean fEnableState;

        EnablementNotifier(boolean enabled) {
            this.fEnableState = enabled;
        }

        public void handleException(Throwable exception) {
            DebugUIPlugin.log(exception);
        }

        public void run() throws Exception {
            int i = 0;
            while (i < MemoryBlockViewSynchronizer.this.fSynchronizerListener.size()) {
                ISynchronizerListener listener = (ISynchronizerListener)MemoryBlockViewSynchronizer.this.fSynchronizerListener.get(i);
                listener.synchronizerEnablementChanged(this.fEnableState);
                ++i;
            }
        }
    }
}

