/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryRenderer;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRendering;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.ITableMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.IntegerRendering;
import org.eclipse.debug.internal.ui.views.memory.RendererUtil;

public class SignedIntegerRenderer
extends AbstractMemoryRenderer {
    private ITableMemoryViewTab fTableViewTab;
    private int fColSize;
    private BigInteger fMax;
    private BigInteger fMin;

    public void setViewTab(IMemoryViewTab viewTab) {
        super.setViewTab(viewTab);
        if (viewTab instanceof ITableMemoryViewTab) {
            this.fTableViewTab = (ITableMemoryViewTab)viewTab;
        }
    }

    private String convertToString(byte[] byteArray, int columnSize, int endianess) {
        long result = 0L;
        if (columnSize == 1) {
            result = byteArray[0];
        } else if (columnSize == 2) {
            result = RendererUtil.convertByteArrayToShort(byteArray, endianess);
        } else if (columnSize == 4) {
            result = RendererUtil.convertByteArrayToInt(byteArray, endianess);
        } else if (columnSize == 8) {
            result = RendererUtil.convertByteArrayToLong(byteArray, endianess);
        } else {
            if (columnSize == 16) {
                BigInteger bigRet = RendererUtil.convertByteArrayToSignedBigInt(byteArray, endianess);
                return bigRet.toString();
            }
            BigInteger bigRet = RendererUtil.convertByteArrayToSignedBigInt(byteArray, endianess, columnSize);
            return bigRet.toString();
        }
        String ret = new Long(result).toString();
        return ret;
    }

    private byte[] convertToBytes(int colSize, String newValue, int endianess) {
        byte[] bytes;
        if (colSize == 1) {
            byte x = Byte.parseByte(newValue);
            bytes = new byte[]{x};
        } else if (colSize == 2) {
            short i = Short.parseShort(newValue);
            bytes = RendererUtil.convertShortToByteArray(i, endianess);
        } else if (colSize == 4) {
            int i = Integer.parseInt(newValue);
            bytes = RendererUtil.convertIntToByteArray(i, endianess);
        } else if (colSize == 8) {
            long i = Long.parseLong(newValue);
            bytes = RendererUtil.convertLongToByteArray(i, endianess);
        } else {
            if (colSize == 16) {
                BigInteger i = new BigInteger(newValue);
                byte[] bytes2 = RendererUtil.convertBigIntegerToByteArray(i, endianess);
                return bytes2;
            }
            BigInteger i = new BigInteger(newValue);
            if (this.fColSize != colSize) {
                this.fColSize = colSize;
                this.fMax = BigInteger.valueOf(2L);
                this.fMax = this.fMax.pow(colSize * 8 - 1);
                this.fMin = this.fMax.multiply(BigInteger.valueOf(-1L));
                this.fMax = this.fMax.subtract(BigInteger.valueOf(1L));
            }
            if (i.compareTo(this.fMax) > 0 || i.compareTo(this.fMin) < 0) {
                throw new NumberFormatException();
            }
            byte[] bytes3 = RendererUtil.convertSignedBigIntToByteArray(i, endianess, colSize);
            return bytes3;
        }
        return bytes;
    }

    private int getEndianess() {
        int endianess = 1;
        IMemoryRendering rendering = this.fTableViewTab.getRendering();
        if (rendering instanceof IntegerRendering) {
            endianess = ((IntegerRendering)rendering).getCurrentEndianess();
        }
        return endianess;
    }

    public String getString(String dataType, BigInteger address, MemoryByte[] data, String paddedStr) {
        boolean invalid = false;
        int i = 0;
        while (i < data.length) {
            if (!data[i].isValid()) {
                invalid = true;
                break;
            }
            ++i;
        }
        if (invalid) {
            StringBuffer strBuf = new StringBuffer();
            int i2 = 0;
            while (i2 < data.length) {
                strBuf.append(paddedStr);
                ++i2;
            }
            return strBuf.toString();
        }
        if (this.fTableViewTab != null) {
            int columnSize = this.fTableViewTab.getBytesPerColumn();
            int endianess = this.getEndianess();
            byte[] byteArray = new byte[data.length];
            int i3 = 0;
            while (i3 < byteArray.length) {
                byteArray[i3] = data[i3].getValue();
                ++i3;
            }
            return this.convertToString(byteArray, columnSize, endianess);
        }
        return "";
    }

    public byte[] getBytes(String dataType, BigInteger address, MemoryByte[] currentValues, String data) {
        if (this.fTableViewTab != null) {
            int columnSize = this.fTableViewTab.getBytesPerColumn();
            int endianess = this.getEndianess();
            return this.convertToBytes(columnSize, data, endianess);
        }
        return new byte[0];
    }
}

