/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class SelectLogicalStructureAction
extends Action {
    private VariablesView fView;
    private ILogicalStructureType[] fTypes;
    private int fIndex;

    public SelectLogicalStructureAction(VariablesView view, ILogicalStructureType[] group, IValue value, int index) {
        super(group[index].getDescription(value), 2);
        this.setView(view);
        this.fTypes = group;
        this.fIndex = index;
    }

    public void run() {
        this.valueChanged();
    }

    private void valueChanged() {
        if (!this.getView().isAvailable()) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getView().getViewer().getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
                int i = 0;
                while (i < SelectLogicalStructureAction.this.fTypes.length) {
                    if (i == SelectLogicalStructureAction.this.fIndex && SelectLogicalStructureAction.this.isChecked()) {
                        store.setValue("VAR_LS_" + SelectLogicalStructureAction.this.fTypes[i].getId(), 1);
                    } else {
                        store.setValue("VAR_LS_" + SelectLogicalStructureAction.this.fTypes[i].getId(), -1);
                    }
                    ++i;
                }
                SelectLogicalStructureAction.this.getView().getViewer().refresh();
            }
        });
    }

    protected VariablesView getView() {
        return this.fView;
    }

    protected void setView(VariablesView view) {
        this.fView = view;
    }
}

