/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.swt.graphics.Image;

public class RefactoringPluginImages {
    private static final String NAME_PREFIX = "org.eclipse.ltk.ui.refactoring";
    private static final int NAME_PREFIX_LENGTH = "org.eclipse.ltk.ui.refactoring".length();
    private static URL fgIconBaseURL = null;
    private static ImageRegistry fgImageRegistry;
    private static HashMap fgAvoidSWTErrorMap;
    private static final String T_WIZBAN = "wizban";
    private static final String T_OBJ = "obj16";
    public static final ImageDescriptor DESC_WIZBAN_REFACTOR;
    public static final String IMG_OBJS_REFACTORING_FATAL = "org.eclipse.ltk.ui.refactoringfatalerror_obj.gif";
    public static final String IMG_OBJS_REFACTORING_ERROR = "org.eclipse.ltk.ui.refactoringerror_obj.gif";
    public static final String IMG_OBJS_REFACTORING_WARNING = "org.eclipse.ltk.ui.refactoringwarning_obj.gif";
    public static final String IMG_OBJS_REFACTORING_INFO = "org.eclipse.ltk.ui.refactoringinfo_obj.gif";
    public static final ImageDescriptor DESC_OBJS_REFACTORING_FATAL;
    public static final ImageDescriptor DESC_OBJS_REFACTORING_ERROR;
    public static final ImageDescriptor DESC_OBJS_REFACTORING_WARNING;
    public static final ImageDescriptor DESC_OBJS_REFACTORING_INFO;
    public static final ImageDescriptor DESC_OBJS_DEFAULT_CHANGE;
    public static final ImageDescriptor DESC_OBJS_COMPOSITE_CHANGE;
    public static final ImageDescriptor DESC_OBJS_CU_CHANGE;
    public static final ImageDescriptor DESC_OBJS_FILE_CHANGE;
    public static final ImageDescriptor DESC_OBJS_TEXT_EDIT;

    static {
        fgIconBaseURL = RefactoringUIPlugin.getDefault().getBundle().getEntry("/icons/full/");
        fgImageRegistry = null;
        fgAvoidSWTErrorMap = null;
        DESC_WIZBAN_REFACTOR = RefactoringPluginImages.create(T_WIZBAN, "refactor_wiz.gif");
        DESC_OBJS_REFACTORING_FATAL = RefactoringPluginImages.createManaged(T_OBJ, IMG_OBJS_REFACTORING_FATAL);
        DESC_OBJS_REFACTORING_ERROR = RefactoringPluginImages.createManaged(T_OBJ, IMG_OBJS_REFACTORING_ERROR);
        DESC_OBJS_REFACTORING_WARNING = RefactoringPluginImages.createManaged(T_OBJ, IMG_OBJS_REFACTORING_WARNING);
        DESC_OBJS_REFACTORING_INFO = RefactoringPluginImages.createManaged(T_OBJ, IMG_OBJS_REFACTORING_INFO);
        DESC_OBJS_DEFAULT_CHANGE = RefactoringPluginImages.create(T_OBJ, "change.gif");
        DESC_OBJS_COMPOSITE_CHANGE = RefactoringPluginImages.create(T_OBJ, "composite_change.gif");
        DESC_OBJS_CU_CHANGE = RefactoringPluginImages.create(T_OBJ, "cu_change.gif");
        DESC_OBJS_FILE_CHANGE = RefactoringPluginImages.create(T_OBJ, "file_change.gif");
        DESC_OBJS_TEXT_EDIT = RefactoringPluginImages.create(T_OBJ, "text_edit.gif");
    }

    public static Image get(String key) {
        return RefactoringPluginImages.getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        RefactoringPluginImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        RefactoringPluginImages.setImageDescriptors(action, "lcl16", iconName);
    }

    static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry();
            Iterator iter = fgAvoidSWTErrorMap.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                fgImageRegistry.put(key, (ImageDescriptor)fgAvoidSWTErrorMap.get(key));
            }
            fgAvoidSWTErrorMap = null;
        }
        return fgImageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)RefactoringPluginImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        ImageDescriptor descriptor = RefactoringPluginImages.create("e" + type, relPath);
        action.setHoverImageDescriptor(descriptor);
        action.setImageDescriptor(descriptor);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)RefactoringPluginImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (fgAvoidSWTErrorMap == null) {
                fgAvoidSWTErrorMap = new HashMap();
            }
            fgAvoidSWTErrorMap.put(name, result);
            if (fgImageRegistry != null) {
                RefactoringUIPlugin.logErrorMessage("Image registry already defined");
            }
            return result;
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)RefactoringPluginImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(fgIconBaseURL, buffer.toString());
    }
}

