/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.search.internal.core.ISearchScope;

public class AmountOfWorkCalculator
implements IResourceProxyVisitor {
    private ISearchScope fScope;
    private int fFileCount;
    private boolean fVisitDerived;
    private final MultiStatus fStatus;

    AmountOfWorkCalculator(MultiStatus status, boolean visitDerived) {
        this.fStatus = status;
        this.fVisitDerived = visitDerived;
    }

    public boolean visit(IResourceProxy proxy) {
        if (proxy.getType() == 1 && this.shouldVisit(proxy)) {
            ++this.fFileCount;
        }
        return true;
    }

    private boolean shouldVisit(IResourceProxy proxy) {
        if (!this.fScope.encloses(proxy)) {
            return false;
        }
        return this.fVisitDerived || !proxy.isDerived();
    }

    public int process(Collection projects, ISearchScope scope) {
        this.fFileCount = 0;
        this.fScope = scope;
        Iterator i = projects.iterator();
        while (i.hasNext()) {
            IProject project = (IProject)i.next();
            int save = this.fFileCount;
            try {
                project.accept((IResourceProxyVisitor)this, 0);
            }
            catch (CoreException ex) {
                this.fStatus.add(ex.getStatus());
            }
            if (save != this.fFileCount) continue;
            i.remove();
        }
        return this.fFileCount;
    }
}

