/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.util.Assert;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.text.AmountOfWorkCalculator;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.MatchLocator;
import org.eclipse.search.internal.core.text.TextSearchVisitor;
import org.eclipse.search.internal.ui.SearchMessages;

public class TextSearchEngine {
    public IStatus search(IWorkspace workspace, ISearchScope scope, boolean visitDerived, ITextSearchResultCollector collector, MatchLocator matchLocator) {
        return this.search(scope, visitDerived, collector, matchLocator, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus search(ISearchScope scope, boolean visitDerived, ITextSearchResultCollector collector, MatchLocator matchLocator, boolean allowNIOSearch) {
        Assert.isNotNull((Object)scope);
        Assert.isNotNull((Object)collector);
        Assert.isNotNull((Object)matchLocator);
        IProgressMonitor monitor = collector.getProgressMonitor();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> openProjects = new ArrayList<IProject>(10);
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project.isOpen()) {
                openProjects.add(project);
            }
            ++i;
        }
        String message = SearchMessages.getString("TextSearchEngine.statusMessage");
        MultiStatus status = new MultiStatus("org.eclipse.search", 0, message, null);
        if (openProjects.isEmpty()) return status;
        int amountOfWork = new AmountOfWorkCalculator(status, visitDerived).process(openProjects, scope);
        try {
            try {
                monitor.beginTask("", amountOfWork);
                if (amountOfWork > 0) {
                    Object[] args = new Integer[]{new Integer(1), new Integer(amountOfWork)};
                    monitor.setTaskName(SearchMessages.getFormattedString("TextSearchEngine.scanning", args));
                }
                collector.aboutToStart();
                TextSearchVisitor visitor = new TextSearchVisitor(matchLocator, scope, visitDerived, collector, status, amountOfWork);
                visitor.setAllowNIOSearch(allowNIOSearch);
                visitor.process(openProjects);
            }
            catch (CoreException ex) {
                status.add(ex.getStatus());
            }
            Object var13_17 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            monitor.done();
            try {
                collector.done();
                throw throwable;
            }
            catch (CoreException ex) {
                status.add(ex.getStatus());
            }
            throw throwable;
        }
        monitor.done();
        try {}
        catch (CoreException ex) {
            status.add(ex.getStatus());
            return status;
        }
        collector.done();
        return status;
    }
}

