/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.util;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ListDialog
extends SelectionDialog {
    private static final int WIDTH_IN_CHARACTERS = 55;
    private IStructuredContentProvider fContentProvider;
    private ILabelProvider fLabelProvider;
    private Object fInput;
    private TableViewer fViewer;
    private boolean fCreateCancelButton = true;

    public ListDialog(Shell parent, Object input, String title, String message, IStructuredContentProvider sp, ILabelProvider lp) {
        super(parent);
        this.setTitle(title);
        this.setMessage(message);
        this.fInput = input;
        this.fContentProvider = sp;
        this.fLabelProvider = lp;
    }

    public void setCreateCancelButton(boolean value) {
        this.fCreateCancelButton = value;
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 64);
        label.setText(this.getMessage());
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(55);
        label.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)label);
        return label;
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        this.createMessageArea(parent);
        this.fViewer = new TableViewer(parent, 2820);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        Table table = this.fViewer.getTable();
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (ListDialog.this.fCreateCancelButton) {
                    ListDialog.this.okPressed();
                }
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.setInput(this.fInput);
        List initialSelection = this.getInitialElementSelections();
        if (initialSelection != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(initialSelection));
        }
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        gd.widthHint = this.convertWidthInCharsToPixels(55);
        table.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)table);
        return table;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.fCreateCancelButton) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        } else {
            super.createButtonsForButtonBar(parent);
        }
    }

    protected void okPressed() {
        ISelection selection = this.fViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setResult(((IStructuredSelection)this.fViewer.getSelection()).toList());
        }
        super.okPressed();
    }
}

