/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text.Highlighter;
import org.eclipse.search2.internal.ui.text.PositionTracker;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationTypeLookup;

public class AnnotationHighlighter
extends Highlighter {
    private IAnnotationModel fModel;
    private IDocument fDocument;
    private Map fMatchesToAnnotations;
    private AnnotationTypeLookup fAnnotationTypeLookup = EditorsUI.getAnnotationTypeLookup();

    public AnnotationHighlighter(IAnnotationModel model, IDocument document) {
        this.fModel = model;
        this.fDocument = document;
        this.fMatchesToAnnotations = new HashMap();
    }

    public void addHighlights(Match[] matches) {
        HashMap<Annotation, Position> map = new HashMap<Annotation, Position>(matches.length);
        int i = 0;
        while (i < matches.length) {
            Position position;
            int offset = matches[i].getOffset();
            int length = matches[i].getLength();
            if (offset >= 0 && length >= 0 && (position = this.createPosition(matches[i])) != null) {
                Annotation annotation = new Annotation(this.fAnnotationTypeLookup.getAnnotationType("org.eclipse.search.searchmarker", 0), true, null);
                this.fMatchesToAnnotations.put(matches[i], annotation);
                map.put(annotation, position);
            }
            ++i;
        }
        this.addAnnotations(map);
    }

    private Position createPosition(Match match) {
        Position position = InternalSearchUI.getInstance().getPositionTracker().getCurrentPosition(match);
        position = position == null ? new Position(match.getOffset(), match.getLength()) : new Position(position.getOffset(), position.getLength());
        if (match.getBaseUnit() == 1) {
            if (this.fDocument != null) {
                try {
                    position = PositionTracker.convertToCharacterPosition(position, this.fDocument);
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            } else {
                SearchPlugin.log((IStatus)new Status(4, SearchPlugin.getID(), 0, SearchMessages.getString("AnnotationHighlighter.error.noDocument"), null));
                return null;
            }
        }
        return position;
    }

    public void removeHighlights(Match[] matches) {
        HashSet<Annotation> annotations = new HashSet<Annotation>(matches.length);
        int i = 0;
        while (i < matches.length) {
            Annotation annotation = (Annotation)this.fMatchesToAnnotations.remove(matches[i]);
            if (annotation != null) {
                annotations.add(annotation);
            }
            ++i;
        }
        this.removeAnnotations(annotations);
    }

    public void removeAll() {
        Collection matchSet = this.fMatchesToAnnotations.values();
        this.removeAnnotations(matchSet);
        this.fMatchesToAnnotations.clear();
    }

    private void addAnnotations(Map annotationToPositionMap) {
        if (this.fModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ame = (IAnnotationModelExtension)this.fModel;
            ame.replaceAnnotations(new Annotation[0], annotationToPositionMap);
        } else {
            Iterator elements = annotationToPositionMap.keySet().iterator();
            while (elements.hasNext()) {
                Annotation element = (Annotation)elements.next();
                Position p = (Position)annotationToPositionMap.get(element);
                this.fModel.addAnnotation(element, p);
            }
        }
    }

    private void removeAnnotations(Collection annotations) {
        if (this.fModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ame = (IAnnotationModelExtension)this.fModel;
            Annotation[] annotationArray = new Annotation[annotations.size()];
            ame.replaceAnnotations(annotations.toArray(annotationArray), Collections.EMPTY_MAP);
        } else {
            Iterator iter = annotations.iterator();
            while (iter.hasNext()) {
                Annotation element = (Annotation)iter.next();
                this.fModel.removeAnnotation(element);
            }
        }
    }

    protected void handleContentReplaced(IFileBuffer buffer) {
        if (!(buffer instanceof ITextFileBuffer)) {
            return;
        }
        ITextFileBuffer textBuffer = (ITextFileBuffer)buffer;
        if (this.fDocument != null && this.fDocument.equals(textBuffer.getDocument())) {
            Set allMatches = this.fMatchesToAnnotations.keySet();
            Match[] matchesCopy = allMatches.toArray(new Match[allMatches.size()]);
            this.removeAll();
            this.addHighlights(matchesCopy);
        }
    }
}

